/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import shetiphian.core.client.model.AssembledBakedModel;
import shetiphian.core.client.model.CompositeBakedModel;
import shetiphian.core.client.model.data.ModelProperties;
import shetiphian.core.common.UseContext;
import shetiphian.multibeds.client.model.CacheBuilder;
import shetiphian.multibeds.common.block.BlockLadderBase;
import shetiphian.multibeds.common.item.ItemBlockLadder;

@OnlyIn(value=Dist.CLIENT)
public class ModelLadder {
    private static void add(List<BakedModel> list, String part, String key, Direction facing, String particle) {
        BakedModel model = CacheBuilder.getLadder(part, key, facing, particle);
        if (model != null) {
            list.add(model);
        }
    }

    private static class ItemHandler {
        static ItemHandler INSTANCE = new ItemHandler();
        private static ItemTransforms transforms;

        private ItemHandler() {
        }

        BakedModel getModel(ItemStack stack, BakedModel original) {
            if (!stack.m_41619_() && stack.m_41720_() instanceof ItemBlockLadder) {
                if (transforms == null) {
                    this.buildTransforms();
                }
                String material = CacheBuilder.INSTANCE.getTexture(ItemBlockLadder.getTextureStack(stack));
                ArrayList<BakedModel> list = new ArrayList<BakedModel>();
                ModelLadder.add(list, "ladder/inventory", material, Direction.SOUTH, material);
                return new AssembledBakedModel(list, new ItemTransforms[]{transforms});
            }
            return original;
        }

        void buildTransforms() {
            ItemTransform thirdperson = this.create(75.0f, 135.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson = this.create(0.0f, 135.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform gui = this.create(30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransform ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform head = ItemTransform.f_111754_;
            ItemTransform fixed = this.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            transforms = new ItemTransforms(thirdperson, thirdperson, firstperson, firstperson, head, gui, ground, fixed);
        }

        private ItemTransform create(float rX, float rY, float rZ, float tX, float tY, float tZ, float sX, float sY, float sZ) {
            Vector3f rotation = new Vector3f(rX, rY, rZ);
            Vector3f translation = new Vector3f(tX, tY, tZ);
            translation.m_122261_(0.0625f);
            translation.m_122242_(-5.0f, 5.0f);
            Vector3f scale = new Vector3f(sX, sY, sZ);
            scale.m_122242_(-4.0f, 4.0f);
            return new ItemTransform(rotation, translation, scale);
        }
    }

    private static class BlockHandler {
        static BlockHandler INSTANCE = new BlockHandler();

        private BlockHandler() {
        }

        List<BakedModel> getList(BlockState state, IModelData data, RenderType layer) {
            CompoundTag nbtTag;
            if (!(state.m_60734_() instanceof BlockLadderBase)) {
                return Collections.emptyList();
            }
            String ladderType = "single";
            ItemStack materialItem = ItemStack.f_41583_;
            if (data.hasProperty(ModelProperties.NBTProperty) && (nbtTag = (CompoundTag)data.getData(ModelProperties.NBTProperty)) != null) {
                if (nbtTag.m_128441_("ladder_type")) {
                    ladderType = nbtTag.m_128461_("ladder_type");
                }
                if (nbtTag.m_128441_("ladder_material")) {
                    materialItem = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("ladder_material"));
                }
            }
            String material = CacheBuilder.INSTANCE.getTexture(materialItem);
            Direction facing = (Direction)state.m_61143_((Property)BlockLadderBase.f_54337_);
            boolean doRender = layer == RenderType.m_110451_();
            BlockState materialState = UseContext.getBlockPlacementStateFor((ItemStack)materialItem);
            doRender = ItemBlockRenderTypes.canRenderInLayer((BlockState)materialState, (RenderType)RenderType.m_110466_()) ? layer == RenderType.m_110466_() : (ItemBlockRenderTypes.canRenderInLayer((BlockState)materialState, (RenderType)RenderType.m_110463_()) || ItemBlockRenderTypes.canRenderInLayer((BlockState)materialState, (RenderType)RenderType.m_110457_()) ? layer == RenderType.m_110463_() : doRender);
            ArrayList<BakedModel> list = new ArrayList<BakedModel>();
            if (doRender) {
                ModelLadder.add(list, "ladder/" + ladderType, material, facing, material);
            }
            return list;
        }
    }

    public static class Baked
    extends CompositeBakedModel {
        public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
            CompoundTag nbtTag;
            ItemStack materialItem = ItemStack.f_41583_;
            if (data.hasProperty(ModelProperties.NBTProperty) && (nbtTag = (CompoundTag)data.getData(ModelProperties.NBTProperty)) != null && nbtTag.m_128441_("ladder_material")) {
                materialItem = ItemStack.m_41712_((CompoundTag)nbtTag.m_128469_("ladder_material"));
            }
            if (materialItem.m_41619_()) {
                materialItem = new ItemStack((ItemLike)Blocks.f_50058_);
            }
            return CacheBuilder.INSTANCE.getTextureSprite(materialItem);
        }

        protected List<BakedModel> handleBlockState(BlockState state, Direction side, Random rand, IModelData data) {
            return BlockHandler.INSTANCE.getList(state, data, MinecraftForgeClient.getRenderType());
        }

        protected BakedModel handleItemState(BakedModel model, ItemStack stack, Level world, LivingEntity entity) {
            return ItemHandler.INSTANCE.getModel(stack, model);
        }
    }

    public static class Geometry
    implements IModelGeometry<Geometry> {
        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return Collections.emptyList();
        }

        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            CacheBuilder.INSTANCE.preBakeSetup(bakery, spriteGetter);
            return new Baked();
        }
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public void m_6213_(ResourceManager resourceManager) {
            CacheBuilder.rebuildCache();
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new Geometry();
        }
    }
}

