/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.render;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.ColorHandler;
import shetiphian.multibeds.Values;
import shetiphian.multibeds.client.model.ModelBed;
import shetiphian.multibeds.client.model.ModelLadder;
import shetiphian.multibeds.client.render.RenderArtOnBed;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="multibeds", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RenderRegistry {
    public static List<Object> COLORIZE = new ArrayList<Object>();
    public static List<Triple<Item, String, ItemPropertyFunction>> OVERRIDES = new ArrayList<Triple<Item, String, ItemPropertyFunction>>();

    @SubscribeEvent
    public static void modelRegistryEvent(ModelRegistryEvent event) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("multibeds:bed"), (IModelLoader)new ModelBed.Loader());
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("multibeds:ladder"), (IModelLoader)new ModelLadder.Loader());
    }

    @SubscribeEvent
    public static void blockColorHandlerEvent(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        for (Object object : COLORIZE) {
            if (!(object instanceof Block)) continue;
            blockColors.m_92589_((BlockColor)ColorHandler.BlockColor.INSTANCE, new Block[]{(Block)object});
        }
    }

    @SubscribeEvent
    public static void itemColorHandlerEvent(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        for (Object object : COLORIZE) {
            if (object instanceof Block) {
                itemColors.m_92689_((ItemColor)ColorHandler.ItemColor.INSTANCE, new ItemLike[]{Item.m_41439_((Block)((Block)object))});
                continue;
            }
            if (!(object instanceof Item)) continue;
            itemColors.m_92689_((ItemColor)ColorHandler.ItemColor.INSTANCE, new ItemLike[]{(Item)object});
        }
    }

    @SubscribeEvent
    public static void entityRenderersEvent(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(Values.tileBed, context -> new RenderArtOnBed());
    }

    public static void setupNow() {
    }

    public static void setupLater() {
        RenderRegistry.setRenderLayer();
        for (Triple<Item, String, ItemPropertyFunction> data : OVERRIDES) {
            ItemProperties.register((Item)((Item)data.getLeft()), (ResourceLocation)new ResourceLocation((String)data.getMiddle()), (ItemPropertyFunction)((ItemPropertyFunction)data.getRight()));
        }
        OVERRIDES.clear();
    }

    private static void setRenderLayer() {
        for (Block block : Values.blocksEarthBed.values()) {
            ItemBlockRenderTypes.setRenderLayer((Block)block, layer -> layer == RenderType.m_110466_() || layer == RenderType.m_110463_() || layer == RenderType.m_110451_());
        }
        ItemBlockRenderTypes.setRenderLayer((Block)Values.blockEarthLadder, layer -> layer == RenderType.m_110466_() || layer == RenderType.m_110463_() || layer == RenderType.m_110451_());
    }
}

