/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.inventory;

import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.multibeds.Values;
import shetiphian.multibeds.common.item.ItemBlockLadder;
import shetiphian.multibeds.common.item.ItemBlockMultiBed;
import shetiphian.multibeds.common.item.ItemBuilderKit;
import shetiphian.multibeds.common.misc.EnumBedStyle;

public class ContainerBuilder
extends AbstractContainerMenu {
    private final BuilderMode builderMode;
    private final DataSlot indexBedStyle = DataSlot.m_39401_();
    private final Slot slotBaseItem;
    private final Slot slotMaterial;
    private final Slot slotOutput;
    private Runnable callbackInventoryChange = () -> {};
    private final Container invOutput = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            ContainerBuilder.this.callbackInventoryChange.run();
        }
    };
    private boolean canUse;
    private ItemStack stackOutput = ItemStack.f_41583_;
    private final Container invInput = new SimpleContainer(2){

        public void m_6596_() {
            super.m_6596_();
            ContainerBuilder.this.m_6199_((Container)this);
            ContainerBuilder.this.callbackInventoryChange.run();
        }
    };

    public static ContainerBuilder Bed(int id, Inventory playerInv) {
        return new ContainerBuilder(id, playerInv, BuilderMode.BED);
    }

    public static ContainerBuilder Ladder(int id, Inventory playerInv) {
        return new ContainerBuilder(id, playerInv, BuilderMode.LADDER);
    }

    private ContainerBuilder(int id, final Inventory playerInv, BuilderMode mode) {
        super(mode.getType(), id);
        this.builderMode = mode;
        this.canUse = true;
        this.slotBaseItem = this.m_38897_(new Slot(this.invInput, 0, 53, 102){

            public boolean m_5857_(ItemStack stack) {
                return ContainerBuilder.this.builderMode.getItemClass().isInstance(stack.m_41720_());
            }
        });
        this.slotMaterial = this.m_38897_(new Slot(this.invInput, 1, 71, 102){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof BlockItem && !(((BlockItem)stack.m_41720_()).m_40614_() instanceof EntityBlock);
            }
        });
        this.slotOutput = this.m_38897_(new Slot(this.invOutput, 0, 113, 102){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                if (player.m_150110_().f_35937_) {
                    super.m_142406_(player, stack);
                    return;
                }
                if (ContainerBuilder.this.slotBaseItem.m_7993_().m_41763_()) {
                    ContainerBuilder.this.slotBaseItem.m_7993_().m_41622_(1, (LivingEntity)player, entity -> {});
                } else {
                    ContainerBuilder.this.slotBaseItem.m_6201_(1);
                }
                ContainerBuilder.this.slotMaterial.m_6201_(1);
                if (ContainerBuilder.this.builderMode == BuilderMode.BED && !ContainerBuilder.this.slotBaseItem.m_6657_()) {
                    for (ItemStack itemStack : playerInv.f_35974_) {
                        if (itemStack.m_41619_() || !(itemStack.m_41720_() instanceof ItemBuilderKit)) continue;
                        super.m_142406_(player, stack);
                        return;
                    }
                    ContainerBuilder.this.canUse = false;
                }
                super.m_142406_(player, stack);
            }
        });
        int pX = 11;
        int pY = 148;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; col = (int)((byte)(col + 1))) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, pX + col * 18, pY));
            }
            pY += 18;
        }
        pY += 4;
        for (int col = 0; col < 9; col = (int)((byte)(col + 1))) {
            this.m_38897_(new Slot((Container)playerInv, col, pX + col * 18, pY));
        }
        this.indexBedStyle.m_6422_(EnumBedStyle.COT.ordinal());
        this.m_38895_(this.indexBedStyle);
        this.slotBaseItem.m_5852_(playerInv.m_36056_().m_41620_(1));
        this.updateOutputStack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBedStyleIndex() {
        return this.indexBedStyle.m_6501_();
    }

    public boolean m_6875_(Player player) {
        return this.canUse || !player.f_36096_.m_142621_().m_41619_();
    }

    public boolean m_6366_(Player player, int id) {
        this.indexBedStyle.m_6422_(Mth.m_14045_((int)id, (int)0, (int)EnumBedStyle.values().length));
        this.updateOutputStack();
        return true;
    }

    private void updateOutputStack() {
        ItemStack stack = this.getUpdatedStack();
        if (!stack.m_41619_()) {
            this.stackOutput = stack;
            this.m_6199_(null);
        }
    }

    private ItemStack getUpdatedStack() {
        switch (this.builderMode) {
            case BED: {
                EnumBedStyle style = EnumBedStyle.byIndex(this.indexBedStyle.m_6501_());
                return ItemBlockMultiBed.createStack(Values.blocksEarthBed.get((Object)style), this.slotMaterial.m_7993_());
            }
            case LADDER: {
                ItemStack stack = ItemBlockLadder.createStack(Values.blockEarthLadder, this.slotMaterial.m_7993_());
                stack.m_41764_(4);
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_6199_(Container inventory) {
        ItemStack stackBedKit = this.slotBaseItem.m_7993_();
        ItemStack stackMaterial = this.slotMaterial.m_7993_();
        if (stackBedKit.m_41619_() || stackMaterial.m_41619_()) {
            this.slotOutput.m_5852_(ItemStack.f_41583_);
        } else {
            if (inventory != null) {
                this.updateOutputStack();
            }
            this.slotOutput.m_5852_(this.stackOutput);
        }
        this.m_38946_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryChangeCallback(Runnable runnable) {
        this.callbackInventoryChange = runnable;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot clickedSlot = (Slot)this.f_38839_.get(index);
        if (clickedSlot != null && clickedSlot.m_6657_()) {
            ItemStack itemInSlot = clickedSlot.m_7993_();
            itemstack = itemInSlot.m_41777_();
            if (index == this.slotOutput.f_40219_) {
                if (!this.m_38903_(itemInSlot, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                clickedSlot.m_40234_(itemInSlot, itemstack);
            } else if (index != this.slotBaseItem.f_40219_ && index != this.slotMaterial.f_40219_ ? (this.slotBaseItem.m_5857_(itemInSlot) ? !this.m_38903_(itemInSlot, this.slotBaseItem.f_40219_, this.slotBaseItem.f_40219_ + 1, false) : (this.slotMaterial.m_5857_(itemInSlot) ? !this.m_38903_(itemInSlot, this.slotMaterial.f_40219_, this.slotMaterial.f_40219_ + 1, false) : (index >= 3 && index < 30 ? !this.m_38903_(itemInSlot, 30, 39, false) : index >= 30 && index < 39 && !this.m_38903_(itemInSlot, 3, 30, false)))) : !this.m_38903_(itemInSlot, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (itemInSlot.m_41619_()) {
                clickedSlot.m_5852_(ItemStack.f_41583_);
            } else {
                clickedSlot.m_6654_();
            }
            if (itemInSlot.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            clickedSlot.m_142406_(player, itemInSlot);
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.m_150411_(player, this.invInput);
    }

    public void m_182406_(int slotID, int stateID, ItemStack stack) {
        super.m_182406_(slotID, stateID, stack);
        this.updateRenderedStack();
    }

    public void m_7511_(int id, int data) {
        super.m_7511_(id, data);
        this.updateRenderedStack();
    }

    private void updateRenderedStack() {
        this.stackOutput = this.getUpdatedStack();
        this.callbackInventoryChange.run();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Slot getSlotBaseItem() {
        return this.slotBaseItem;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Slot getSlotMaterial() {
        return this.slotMaterial;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getPreviewItem() {
        return this.slotOutput.m_6657_() ? this.slotOutput.m_7993_() : this.stackOutput;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BuilderMode getBuilderMode() {
        return this.builderMode;
    }

    public static enum BuilderMode {
        BED(Values.Container.BED_KIT, ItemBuilderKit.Bed.class),
        LADDER(Values.Container.LADDER_KIT, ItemBuilderKit.Ladder.class);

        private final MenuType<?> type;
        private final Class itemClass;

        private BuilderMode(MenuType<?> type, Class itemClass) {
            this.type = type;
            this.itemClass = itemClass;
        }

        MenuType<?> getType() {
            return this.type;
        }

        Class getItemClass() {
            return this.itemClass;
        }
    }
}

