/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.loot;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;

public class BannerLootHandler
extends LootModifier {
    protected BannerLootHandler(LootItemCondition[] conditions) {
        super(conditions);
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        CompoundTag tileNBT;
        BlockEntity tile = (BlockEntity)context.m_78953_(LootContextParams.f_81462_);
        if (tile != null && (tileNBT = tile.getTileData()).m_128441_("multibeds")) {
            CompoundTag embroidery = tileNBT.m_128469_("multibeds");
            for (ItemStack stack : generatedLoot) {
                if (stack.m_41619_() || !(stack.m_41720_() instanceof BannerItem)) continue;
                ItemEmbroideryThread.writeEmbroideryData(stack, embroidery);
            }
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<BannerLootHandler> {
        public BannerLootHandler read(ResourceLocation name, JsonObject json, LootItemCondition[] conditions) {
            return new BannerLootHandler(conditions);
        }

        public JsonObject write(BannerLootHandler instance) {
            return this.makeConditions(new LootItemCondition[0]);
        }
    }
}

