/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.modintegration.theoneprobe;

import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.misc.EnumSpreadArt;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public class OneProbeDataProvider
implements IProbeInfoProvider {
    static final OneProbeDataProvider INSTANCE = new OneProbeDataProvider();
    private static final ResourceLocation INFO_PROVIDER_ID = new ResourceLocation("multibeds", "default");
    private static final ItemStack DEFAULT = new ItemStack((ItemLike)Blocks.f_50705_);

    public ResourceLocation getID() {
        return INFO_PROVIDER_ID;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        BlockEntity tile = world.m_7702_(data.getPos());
        if (tile instanceof TileEntityMultiBed) {
            TileEntityMultiBed bed = (TileEntityMultiBed)tile;
            if (!player.m_6144_()) {
                ItemStack textureStack = bed.getBedTextureBlock();
                if (!textureStack.m_41619_()) {
                    probeInfo.text((Component)new TextComponent("\u00a77\u00a7o * ").m_7220_((Component)new TranslatableComponent(textureStack.m_41778_())));
                } else {
                    probeInfo.text((Component)new TextComponent("\u00a77\u00a7o * /!\\ ").m_7220_((Component)new TranslatableComponent("info.shetiphian.texture.missing")).m_130946_(" /!\\"));
                    probeInfo.text((Component)new TextComponent("\u00a77\u00a7o ** ").m_7220_((Component)new TranslatableComponent("info.shetiphian.texture.defaulted")).m_7220_((Component)new TranslatableComponent(DEFAULT.m_41778_())));
                }
            } else {
                ItemStack sheet;
                ItemStack pillow;
                DyeColor color;
                if (bed.hasBlanket()) {
                    ItemStack blanket = bed.getBlanketItem();
                    if (blanket.m_41720_() instanceof ItemBlanket) {
                        color = ((ItemBlanket)blanket.m_41720_()).getColor(blanket);
                        String pattern = ItemBlanket.getPatternName(blanket);
                        if (pattern.equalsIgnoreCase("plain")) {
                            probeInfo.text((Component)new TextComponent("\u00a77\u00a7o + ").m_7220_((Component)new TranslatableComponent("color." + color.m_41065_())).m_130946_(" ").m_7220_((Component)new TranslatableComponent("item.multibeds.blanket")));
                        } else {
                            probeInfo.text((Component)new TextComponent("\u00a77\u00a7o + ").m_7220_((Component)new TranslatableComponent("color." + color.m_41065_())).m_130946_(" ").m_7220_((Component)new TranslatableComponent("misc.multibeds.pattern." + pattern)).m_130946_(" ").m_7220_((Component)new TranslatableComponent("item.multibeds.blanket")));
                        }
                    } else if (blanket.m_41720_() instanceof BannerItem) {
                        probeInfo.text((Component)new TextComponent("\u00a77\u00a7o + ").m_7220_((Component)new TranslatableComponent(blanket.m_41778_())));
                    }
                    EnumSpreadArt art = ItemEmbroideryThread.getArtwork(blanket);
                    if (art != EnumSpreadArt.NONE) {
                        probeInfo.text((Component)new TextComponent("\u00a77\u00a7o * ").m_7220_((Component)new TranslatableComponent("misc.multibeds.art")).m_130946_(": ").m_7220_((Component)new TranslatableComponent("misc.multibeds.art." + art.m_7912_())));
                    }
                }
                if (bed.hasPillow() && (pillow = bed.getPillowItem()).m_41720_() instanceof ItemBedCustomization) {
                    color = ((ItemBedCustomization)pillow.m_41720_()).getColor(pillow);
                    probeInfo.text((Component)new TextComponent("\u00a77\u00a7o + ").m_7220_((Component)new TranslatableComponent("color." + color.m_41065_())).m_130946_(" ").m_7220_((Component)new TranslatableComponent("item.multibeds.pillow")));
                }
                if (bed.hasSheet() && (sheet = bed.getSheetItem()).m_41720_() instanceof ItemBedCustomization) {
                    color = ((ItemBedCustomization)sheet.m_41720_()).getColor(sheet);
                    probeInfo.text((Component)new TextComponent("\u00a77\u00a7o + ").m_7220_((Component)new TranslatableComponent("color." + color.m_41065_())).m_130946_(" ").m_7220_((Component)new TranslatableComponent("item.multibeds.sheet")));
                }
            }
        }
    }
}

