/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat;

import com.sun.jna.Platform;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.config.ClientConfig;
import de.maxhenkel.voicechat.config.PlayerVolumeConfig;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.macos.PermissionCheck;
import de.maxhenkel.voicechat.macos.jna.avfoundation.AVAuthorizationStatus;
import de.maxhenkel.voicechat.profile.UsernameCache;
import de.maxhenkel.voicechat.resourcepacks.VoiceChatResourcePack;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.MacOSUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;

public abstract class VoicechatClient {
    public static ClientConfig CLIENT_CONFIG;
    public static PlayerVolumeConfig VOLUME_CONFIG;
    public static UsernameCache USERNAME_CACHE;
    public static VoiceChatResourcePack CLASSIC_ICONS;
    public static VoiceChatResourcePack WHITE_ICONS;
    public static VoiceChatResourcePack BLACK_ICONS;

    public void initializeClient() {
        ClientCompatibilityManager.INSTANCE = this.createCompatibilityManager();
        this.fixVolumeConfig();
        VOLUME_CONFIG = new PlayerVolumeConfig(Minecraft.m_91087_().f_91069_.toPath().resolve("config").resolve("voicechat").resolve("voicechat-volumes.properties"));
        USERNAME_CACHE = new UsernameCache(Minecraft.m_91087_().f_91069_.toPath().resolve("config").resolve("voicechat").resolve("username-cache.json").toFile());
        ClientManager.instance();
        CLASSIC_ICONS = new VoiceChatResourcePack("Classic Icons", "classic_icons");
        WHITE_ICONS = new VoiceChatResourcePack("White Icons", "white_icons");
        BLACK_ICONS = new VoiceChatResourcePack("Black Icons", "black_icons");
        ClientCompatibilityManager.INSTANCE.addResourcePackSource(Minecraft.m_91087_().m_91099_(), (consumer, packConstructor) -> {
            consumer.accept(Pack.m_10430_((String)CLASSIC_ICONS.m_8017_(), (boolean)false, () -> CLASSIC_ICONS, (Pack.PackConstructor)packConstructor, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_));
            consumer.accept(Pack.m_10430_((String)WHITE_ICONS.m_8017_(), (boolean)false, () -> WHITE_ICONS, (Pack.PackConstructor)packConstructor, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_));
            consumer.accept(Pack.m_10430_((String)BLACK_ICONS.m_8017_(), (boolean)false, () -> BLACK_ICONS, (Pack.PackConstructor)packConstructor, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_));
        });
        if (Platform.isMac() && VoicechatClient.CLIENT_CONFIG.macosMicrophoneWorkaround.get().booleanValue()) {
            Voicechat.LOGGER.info("Running MacOS microphone permission check");
            AVAuthorizationStatus status = PermissionCheck.getMicrophonePermissions();
            Voicechat.LOGGER.info("MacOS microphone permission: {}", (Object)status.name());
            if (!status.equals((Object)AVAuthorizationStatus.AUTHORIZED)) {
                MacOSUtils.checkPermissionInSeparateProcess();
            }
        }
    }

    private void fixVolumeConfig() {
        Path oldLocation = Minecraft.m_91087_().f_91069_.toPath().resolve("config").resolve("voicechat-volumes.properties");
        Path newLocation = Minecraft.m_91087_().f_91069_.toPath().resolve("config").resolve("voicechat").resolve("voicechat-volumes.properties");
        if (!newLocation.toFile().exists() && oldLocation.toFile().exists()) {
            try {
                Files.move(oldLocation, newLocation, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                Voicechat.LOGGER.error("Failed to move volumes config: {}", (Object)e.getMessage());
            }
        }
    }

    protected abstract ClientCompatibilityManager createCompatibilityManager();
}

