/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import com.google.common.collect.Lists;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.volume.PlayerVolumeEntry;
import de.maxhenkel.voicechat.gui.widgets.ListScreenListBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.Util;

public class AdjustVolumeList
extends ListScreenListBase<PlayerVolumeEntry> {
    protected final List<PlayerVolumeEntry> players = Lists.newArrayList();
    protected String filter = "";

    public AdjustVolumeList(int width, int height, int x, int y, int size) {
        super(width, height, x, y, size);
        this.m_93488_(false);
        this.m_93496_(false);
        this.updatePlayerList(ClientManager.getPlayerStateManager().getPlayerStates(false));
    }

    public void tick() {
        List<PlayerState> playerStates = ClientManager.getPlayerStateManager().getPlayerStates(false);
        if (this.hasChanged(playerStates)) {
            this.updatePlayerList(playerStates);
        }
    }

    private boolean hasChanged(List<PlayerState> playerStates) {
        for (PlayerState state : playerStates) {
            boolean match = this.players.stream().anyMatch(entry -> entry.getState().getUuid().equals(state.getUuid()));
            if (match) continue;
            return true;
        }
        return false;
    }

    public void updatePlayerList(Collection<PlayerState> onlinePlayers) {
        this.players.clear();
        for (PlayerState state : onlinePlayers) {
            this.players.add(new PlayerVolumeEntry(state));
        }
        if (VoicechatClient.CLIENT_CONFIG.offlinePlayerVolumeAdjustment.get().booleanValue()) {
            this.addOfflinePlayers(onlinePlayers);
        }
        this.updateFilter();
    }

    private void addOfflinePlayers(Collection<PlayerState> onlinePlayers) {
        for (UUID uuid : VoicechatClient.VOLUME_CONFIG.getVolumes().keySet()) {
            String name;
            if (uuid.equals(Util.f_137441_) || onlinePlayers.stream().anyMatch(state -> uuid.equals(state.getUuid())) || (name = VoicechatClient.USERNAME_CACHE.getUsername(uuid)) == null) continue;
            this.players.add(new PlayerVolumeEntry(new PlayerState(uuid, name, false, true)));
        }
    }

    public void updateFilter() {
        this.m_93516_();
        ArrayList<PlayerVolumeEntry> filteredPlayers = new ArrayList<PlayerVolumeEntry>(this.players);
        if (!this.filter.isEmpty()) {
            filteredPlayers.removeIf(playerEntry -> playerEntry.getState() == null || !playerEntry.getState().getName().toLowerCase(Locale.ROOT).contains(this.filter));
        }
        filteredPlayers.sort((e1, e2) -> e1.getState().getName().compareToIgnoreCase(e2.getState().getName()));
        if (this.filter.isEmpty()) {
            filteredPlayers.add(0, new PlayerVolumeEntry(null));
        }
        this.m_5988_(filteredPlayers);
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.updateFilter();
    }

    public boolean isEmpty() {
        return this.m_6702_().isEmpty();
    }
}

