/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.teams;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.level.saveddata.SavedData;
import shetiphian.core.ShetiPhianCore;
import shetiphian.core.internal.teams.PlayerTeam;
import shetiphian.core.internal.teams.TeamHelper;

public class TeamSaveData
extends SavedData {
    final Map<String, PlayerTeam> TEAMS = new HashMap<String, PlayerTeam>();
    private boolean skipMigration = false;

    void migrate(MinecraftServer server) {
        if (!this.skipMigration) {
            CompoundTag fileNBT = new CompoundTag();
            if (fileNBT.m_128431_().isEmpty()) {
                ShetiPhianCore.LOGGER.info("Importing Scoreboard Teams");
                ServerScoreboard scoreboard = server.m_129896_();
                scoreboard.m_83491_().forEach(scorePlayerTeam -> {
                    CompoundTag teamNBT = new CompoundTag();
                    teamNBT.m_128359_("display_name", Component.Serializer.m_130703_((Component)scorePlayerTeam.m_83364_()));
                    ListTag memberNBT = new ListTag();
                    scorePlayerTeam.m_6809_().forEach(playerName -> {
                        Optional gameprofile = server.m_129927_().m_10996_(playerName);
                        gameprofile.ifPresent(gameProfile -> memberNBT.add((Object)NbtUtils.m_129226_((UUID)gameProfile.getId())));
                    });
                    teamNBT.m_128365_("members", (Tag)memberNBT);
                    teamNBT.m_128365_("managers", (Tag)memberNBT);
                    fileNBT.m_128365_(scorePlayerTeam.m_5758_(), (Tag)teamNBT);
                });
            }
            this.read(fileNBT);
            this.m_77762_();
        }
    }

    public void read(CompoundTag fileNBT) {
        this.skipMigration = true;
        TeamHelper.PLAYER_TEAM.clear();
        this.TEAMS.clear();
        for (String teamId : fileNBT.m_128431_()) {
            if (!(fileNBT.m_128423_(teamId) instanceof CompoundTag)) continue;
            PlayerTeam team = PlayerTeam.load(teamId, fileNBT.m_128469_(teamId));
            this.TEAMS.put(teamId, team);
            team.getMembers().forEach(member -> TeamHelper.PLAYER_TEAM.put((UUID)member, team));
        }
    }

    public CompoundTag m_7176_(CompoundTag fileNBT) {
        this.TEAMS.forEach((teamId, team) -> fileNBT.m_128365_(teamId, (Tag)team.write()));
        return fileNBT;
    }

    public static TeamSaveData load(CompoundTag fileNBT) {
        TeamSaveData saveData = new TeamSaveData();
        saveData.read(fileNBT);
        return saveData;
    }
}

