/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigMain {
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static final ConfigMain CONFIG;
    public final ForgeConfigSpec.BooleanValue allowRemoveCalls;
    public final ForgeConfigSpec.BooleanValue enableCallBubbling;
    public final ForgeConfigSpec.BooleanValue removeLookGoal;
    public final ForgeConfigSpec.BooleanValue removeLookRandom;
    public final ForgeConfigSpec.BooleanValue replaceLookController;
    public final ForgeConfigSpec.BooleanValue removeFishSwim;
    public final ForgeConfigSpec.BooleanValue removeFishAvoidPlayer;
    public final ForgeConfigSpec.BooleanValue removeFishPanic;
    public final ForgeConfigSpec.BooleanValue removeFishFollowLeader;
    public final ForgeConfigSpec.BooleanValue removeFishPuff;
    public final ForgeConfigSpec.BooleanValue removeSquidFlee;
    public final ForgeConfigSpec.BooleanValue removeRandomMove;
    public final AnimalConfigSection cow;
    public final AnimalConfigSection chicken;
    public final AnimalConfigSection pig;
    public final AnimalConfigSection sheep;
    public final ForgeConfigSpec.BooleanValue removeSheepEatBlock;

    ConfigMain(ForgeConfigSpec.Builder builder) {
        builder.comment("Entity Settings").push("entity");
        builder.comment("General").push("general");
        this.allowRemoveCalls = builder.comment("Allow AI tasks to be removed from entities at runtime. If this is disable no per mob or per mob type removes will run.").define("allow_remove_calls", true);
        this.enableCallBubbling = builder.comment("Allows repeat remove calls to bubble to the top of the list to improve performance of repeat mob spawning.").define("enable_call_bubbling", true);
        builder.pop();
        builder.comment("Entity Mob").push("mob");
        this.removeLookGoal = builder.comment("Remove the look at goal (player or attack target) AI task. This will cause AIs to not face targets or walking directions.").define("remove_look_goal", false);
        this.removeLookRandom = builder.comment("Remove the look at random position AI task. This will cause AIs to feel a little lifeless as they do not animate head movement while idle.").define("remove_look_random", false);
        this.replaceLookController = builder.comment("Replaces the default look controller with a version featuring cached tan math improving performance. Only works on vanilla style mobs, if a mod overrides the look controller it will skip.").define("replace_look_controller", true);
        builder.pop();
        builder.comment("Entity Fish").push("fish");
        this.removeFishSwim = builder.comment("Remove the fish's random swimming pathfinder. This will cause fish to stay in position more often.").define("remove_swim", false);
        this.removeFishPanic = builder.comment("Remove the fish's panic pathfinder. This will cause fish to not run away.").define("remove_panic", false);
        this.removeFishAvoidPlayer = builder.comment("Remove the fish's AI task to avoid players.").define("remove_avoid_player", false);
        this.removeFishFollowLeader = builder.comment("Remove the fish's AI task to follow a leader fish to act as a group of fish.").define("remove_follow_leader", false);
        this.removeFishPuff = builder.comment("Remove the fish's AI task to puff up when entities are nearby").define("remove_puff", false);
        builder.pop();
        builder.comment("Squid Fish").push("squid");
        this.removeSquidFlee = builder.comment("Remove the squid's flee pathfinder. This will cause squid to not run away.").define("remove_flee", false);
        this.removeRandomMove = builder.comment("Remove the squid's random movement pathfinder. This will cause squid to swim around randomly.").define("remove_random_move", false);
        builder.pop();
        this.cow = this.createAnimalConfigSection(builder, "Cow", "cow", "cows", true);
        this.chicken = this.createAnimalConfigSection(builder, "Chicken", "chicken", "chickens", true);
        this.pig = this.createAnimalConfigSection(builder, "Pig", "pig", "pigs", true);
        this.sheep = this.createAnimalConfigSection(builder, "Sheep", "sheep", "sheep", false);
        this.removeSheepEatBlock = builder.comment("Remove the sheep's eat block AI task. This causes sheep to no longer eat grass, and thus be unable to regenerate their wool.").define("remove_eat_block", false);
        builder.pop();
        builder.pop();
    }

    private AnimalConfigSection createAnimalConfigSection(ForgeConfigSpec.Builder builder, String categoryComment, String singular, String plural, boolean shouldPop) {
        builder.comment(categoryComment).push(singular);
        AnimalConfigSection animalConfig = new AnimalConfigSection(builder.comment(String.format("Remove the %s's float AI task. This causes %s to no longer swim in water.", singular, plural)).define("remove_float", false), builder.comment(String.format("Remove the %s's panic AI task. This causes %s to no longer run around after being hit, or search water to extinguish themselves.", singular, plural)).define("remove_panic", false), builder.comment(String.format("Remove the %s's breed AI task. This causes %s to be unable to breed to create offspring.", singular, plural)).define("remove_breed", false), builder.comment(String.format("Remove the %s's tempt AI task. This causes %s to no longer follow the player if they're holding an item they like.", singular, plural)).define("remove_tempt", false), builder.comment(String.format("Remove the %s's follow parent AI task. This causes baby %s to no longer follow their parents.", singular, plural)).define("remove_follow_parent", false), builder.comment(String.format("Remove the %s's random stroll AI task. This causes %s to no longer walk around randomly.", singular, plural)).define("remove_stroll", false));
        if (shouldPop) {
            builder.pop();
        }
        return animalConfig;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ConfigMain::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (ConfigMain)specPair.getLeft();
    }

    public record AnimalConfigSection(ForgeConfigSpec.BooleanValue removeFloat, ForgeConfigSpec.BooleanValue removePanic, ForgeConfigSpec.BooleanValue removeBreed, ForgeConfigSpec.BooleanValue removeTempt, ForgeConfigSpec.BooleanValue removeFollowParent, ForgeConfigSpec.BooleanValue removeStroll) {
    }
}

