/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.supermartijn642.chunkloaders.ChunkLoaderTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ChunkLoaderTileRenderer
implements BlockEntityRenderer<ChunkLoaderTile> {
    private final Block block;
    private final boolean fullRotation;

    public ChunkLoaderTileRenderer(Block block, boolean fullRotation) {
        this.block = block;
        this.fullRotation = fullRotation;
    }

    public void render(ChunkLoaderTile tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        matrixStack.m_85836_();
        double offset = Math.sin((double)((float)((System.currentTimeMillis() + (long)tile.animationOffset) % 5000L) / 5000.0f * 2.0f) * Math.PI) * 0.1;
        matrixStack.m_85837_(0.0, offset, 0.0);
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        if (this.fullRotation) {
            float angleX = (float)((System.currentTimeMillis() + (long)tile.animationOffset) % 13000L) / 13000.0f * 360.0f;
            float angleY = (float)((System.currentTimeMillis() + (long)tile.animationOffset) % 15000L) / 15000.0f * 360.0f;
            float angleZ = (float)((System.currentTimeMillis() + (long)tile.animationOffset) % 16000L) / 16000.0f * 360.0f;
            matrixStack.m_85845_(new Quaternion(angleX, angleY, angleZ, true));
        } else {
            float angle = (float)((System.currentTimeMillis() + (long)tile.animationOffset) % 11000L) / 11000.0f * 360.0f;
            matrixStack.m_85845_(new Quaternion(0.0f, angle, 0.0f, true));
        }
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        for (RenderType type : RenderType.m_110506_()) {
            if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)this.block.m_49966_(), (RenderType)type)) continue;
            BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
            BakedModel model = blockRenderer.m_110910_(this.block.m_49966_());
            blockRenderer.m_110937_().renderModel(matrixStack.m_85850_(), buffer.m_6299_(type), this.block.m_49966_(), model, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
        }
        matrixStack.m_85849_();
    }
}

