/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import java.awt.Color;
import java.nio.ByteBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.lwjgl.opengl.GL11;

public class ChunkImage {
    private final Level world;
    private final ChunkPos chunkPos;
    public int textureId = -1;
    private byte[] buffer = null;

    public ChunkImage(Level world, ChunkPos chunkPos) {
        this.world = world;
        this.chunkPos = chunkPos;
    }

    public void createTexture() {
        this.textureId = TextureUtil.m_85280_();
    }

    public void updateTexture() {
        if (this.buffer == null) {
            this.buffer = this.createBuffer();
            GlStateManager.m_84544_((int)this.textureId);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.buffer.length);
            buffer.put(this.buffer).flip();
            GL11.glTexImage2D((int)3553, (int)0, (int)32849, (int)16, (int)16, (int)0, (int)6407, (int)5121, (ByteBuffer)buffer);
        }
    }

    private byte[] createBuffer() {
        int width = 16;
        int height = 16;
        byte[] rgbArray = new byte[width * height * 3];
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < height; ++z) {
                BlockPos pos = this.world.m_5452_(Heightmap.Types.WORLD_SURFACE, new BlockPos(this.chunkPos.m_45604_() + x, 0, this.chunkPos.m_45605_() + z)).m_7495_();
                int northY = this.world.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_() - 1) - 1;
                int westY = this.world.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_() - 1, pos.m_123343_()) - 1;
                BlockState state = this.world.m_8055_(pos);
                int rgb = state.m_60780_((BlockGetter)this.world, (BlockPos)pos).f_76396_;
                Color color = new Color(rgb);
                if (pos.m_123342_() > northY && northY >= 0 || pos.m_123342_() > westY && westY >= 0) {
                    color = color.brighter();
                }
                if (pos.m_123342_() < northY && northY >= 0 || pos.m_123342_() < westY && westY >= 0) {
                    color = color.darker();
                }
                rgb = color.getRGB();
                int index = (x + z * width) * 3;
                rgbArray[index] = (byte)(rgb >> 16 & 0xFF);
                rgbArray[index + 1] = (byte)(rgb >> 8 & 0xFF);
                rgbArray[index + 2] = (byte)(rgb & 0xFF);
            }
        }
        return rgbArray;
    }
}

