/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.bookmarks;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.config.BookmarkConfig;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.ingredients.TypedIngredient;
import net.minecraft.world.item.ItemStack;

public class BookmarkList
implements IIngredientGridSource {
    private final List<ITypedIngredient<?>> list = new LinkedList();
    private final RegisteredIngredients registeredIngredients;
    private final BookmarkConfig bookmarkConfig;
    private final List<IIngredientGridSource.SourceListChangedListener> listeners = new ArrayList<IIngredientGridSource.SourceListChangedListener>();

    public BookmarkList(RegisteredIngredients registeredIngredients, BookmarkConfig bookmarkConfig) {
        this.registeredIngredients = registeredIngredients;
        this.bookmarkConfig = bookmarkConfig;
    }

    public <T> boolean add(ITypedIngredient<T> value) {
        if (this.contains(value)) {
            return false;
        }
        this.addToList(value, true);
        this.notifyListenersOfChange();
        this.bookmarkConfig.saveBookmarks(this.registeredIngredients, this.list);
        return true;
    }

    private <T> boolean contains(ITypedIngredient<T> value) {
        return this.indexOf(value) >= 0;
    }

    private <T> int indexOf(ITypedIngredient<T> value) {
        Optional<ITypedIngredient<T>> normalized = TypedIngredient.normalize(this.registeredIngredients, value);
        if (normalized.isEmpty()) {
            return -1;
        }
        value = normalized.get();
        IIngredientHelper<T> ingredientHelper = this.registeredIngredients.getIngredientHelper(value.getType());
        String uniqueId = ingredientHelper.getUniqueId(value.getIngredient(), UidContext.Ingredient);
        for (int i = 0; i < this.list.size(); ++i) {
            ITypedIngredient<?> existing = this.list.get(i);
            if (!BookmarkList.equal(ingredientHelper, value, uniqueId, existing)) continue;
            return i;
        }
        return -1;
    }

    private static <T> boolean equal(IIngredientHelper<T> ingredientHelper, ITypedIngredient<T> a, String uidA, ITypedIngredient<?> b) {
        Optional<T> filteredB;
        if (a.getIngredient() == b.getIngredient()) {
            return true;
        }
        Object object = a.getIngredient();
        if (object instanceof ItemStack) {
            ItemStack itemStackA = (ItemStack)object;
            object = b.getIngredient();
            if (object instanceof ItemStack) {
                ItemStack itemStackB = (ItemStack)object;
                return ItemStack.m_41728_((ItemStack)itemStackA, (ItemStack)itemStackB);
            }
        }
        if ((filteredB = b.getIngredient(a.getType())).isPresent()) {
            T ingredientB = filteredB.get();
            String uidB = ingredientHelper.getUniqueId(ingredientB, UidContext.Ingredient);
            return uidA.equals(uidB);
        }
        return false;
    }

    public <T> boolean remove(ITypedIngredient<T> ingredient) {
        int index = this.indexOf(ingredient);
        if (index < 0) {
            return false;
        }
        this.list.remove(index);
        this.notifyListenersOfChange();
        this.bookmarkConfig.saveBookmarks(this.registeredIngredients, this.list);
        return true;
    }

    public <T> void addToList(ITypedIngredient<T> value, boolean addToFront) {
        Optional<ITypedIngredient<T>> result = TypedIngredient.normalize(this.registeredIngredients, value);
        if (result.isEmpty()) {
            return;
        }
        value = result.get();
        if (addToFront) {
            this.list.add(0, value);
        } else {
            this.list.add(value);
        }
    }

    @Override
    public List<ITypedIngredient<?>> getIngredientList() {
        return this.list;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public void addSourceListChangedListener(IIngredientGridSource.SourceListChangedListener listener) {
        this.listeners.add(listener);
    }

    public void notifyListenersOfChange() {
        for (IIngredientGridSource.SourceListChangedListener listener : this.listeners) {
            listener.onSourceListChanged();
        }
    }
}

