/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import org.jetbrains.annotations.Nullable;

public class IngredientSet<V>
extends AbstractSet<V> {
    private final Function<V, String> uidGenerator;
    private final Map<String, V> ingredients;

    public static <V> IngredientSet<V> create(IIngredientHelper<V> ingredientHelper, UidContext context) {
        Function<Object, String> uidGenerator = v -> ingredientHelper.getUniqueId(v, context);
        return new IngredientSet<Object>(uidGenerator);
    }

    private IngredientSet(Function<V, String> uidGenerator) {
        this.uidGenerator = uidGenerator;
        this.ingredients = new LinkedHashMap<String, V>();
    }

    @Override
    public boolean add(V v) {
        String uid = this.uidGenerator.apply(v);
        return this.ingredients.put(uid, v) == null;
    }

    @Override
    public boolean remove(Object o) {
        String uid = this.uidGenerator.apply(o);
        return this.ingredients.remove(uid) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof IngredientSet) {
            return super.removeAll(c);
        }
        Objects.requireNonNull(c);
        boolean modified = false;
        for (Object aC : c) {
            modified |= this.remove(aC);
        }
        return modified;
    }

    @Override
    public boolean contains(Object o) {
        String uid = this.uidGenerator.apply(o);
        return this.ingredients.containsKey(uid);
    }

    @Nullable
    public V getByUid(String uid) {
        return this.ingredients.get(uid);
    }

    @Override
    public void clear() {
        this.ingredients.clear();
    }

    @Override
    public Iterator<V> iterator() {
        return this.ingredients.values().iterator();
    }

    @Override
    public int size() {
        return this.ingredients.size();
    }
}

