/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network.packets;

import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.network.IPacketId;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketData;
import mezz.jei.common.network.packets.PacketJei;
import mezz.jei.core.config.GiveMode;
import mezz.jei.core.config.IServerConfig;
import mezz.jei.util.ServerCommandUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class PacketGiveItemStack
extends PacketJei {
    private final ItemStack itemStack;
    private final GiveMode giveMode;

    public PacketGiveItemStack(ItemStack itemStack, GiveMode giveMode) {
        this.itemStack = itemStack;
        this.giveMode = giveMode;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.GIVE_ITEM;
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) {
        buf.m_130055_(this.itemStack);
        buf.m_130068_((Enum)this.giveMode);
    }

    public static void readPacketData(ServerPacketData data) {
        ServerPlayer player = data.player();
        FriendlyByteBuf buf = data.buf();
        ItemStack itemStack = buf.m_130267_();
        if (!itemStack.m_41619_()) {
            GiveMode giveMode = (GiveMode)buf.m_130066_(GiveMode.class);
            IServerConfig serverConfig = data.serverConfig();
            IConnectionToClient connection = data.connection();
            ServerCommandUtil.executeGive(player, itemStack, giveMode, serverConfig, connection);
        }
    }
}

