/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.inventory;

import net.minecraft.world.Container;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.inventory.GuiSlot;
import team.creative.creativecore.common.gui.style.ControlFormatting;

public class GuiInventoryGrid
extends GuiParent {
    public final Container container;
    protected boolean hasFixedSize = true;
    protected boolean reverse = false;
    private int cols;
    private int rows;
    private int cachedCols;
    private int cachedRows;

    public GuiInventoryGrid(String name, Container container) {
        this(name, container, (int)Math.ceil(Math.sqrt(container.m_6643_())));
        this.hasFixedSize = false;
    }

    public GuiInventoryGrid(String name, Container container, int cols) {
        this(name, container, cols, (int)Math.ceil((double)container.m_6643_() / (double)cols));
    }

    public GuiInventoryGrid(String name, Container container, int cols, int rows) {
        super(name);
        this.cols = cols;
        this.rows = rows;
        this.container = container;
        int size = Math.min(container.m_6643_(), cols * rows);
        for (int i = 0; i < size; ++i) {
            GuiChildControl child = super.add(new GuiSlot(container, i));
            child.rect.maxX = 18.0;
            child.rect.maxY = 18.0;
        }
    }

    @Override
    @Deprecated
    public GuiChildControl add(GuiControl control) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMinWidth() {
        return this.hasFixedSize ? this.cols * 18 : 18;
    }

    @Override
    public int getMinHeight() {
        return this.hasFixedSize ? this.rows * 18 : 18;
    }

    @Override
    public void flowX(int width, int preferred) {
        this.cachedCols = width / 18;
        if (this.hasFixedSize) {
            this.cachedCols = Math.min(this.cachedCols, this.cols);
        }
        int offset = (width - this.cachedCols * 18) / 2;
        int i = 0;
        for (GuiChildControl control : this.controls) {
            control.setX(offset + i % this.cachedCols * 18);
            control.flowX();
            ++i;
        }
    }

    @Override
    public void flowY(int height, int preferred) {
        this.cachedRows = height / 18;
        if (this.hasFixedSize) {
            this.cachedRows = Math.min(this.cachedRows, this.rows);
        }
        int offset = (height - this.cachedRows * 18) / 2;
        int i = this.reverse ? this.controls.size() - 1 : 0;
        for (GuiChildControl control : this.controls) {
            int row = i / this.cachedCols;
            control.setY(offset + row * 18);
            control.flowY();
            control.control.visible = row <= this.cachedRows;
            if (this.reverse) {
                --i;
                continue;
            }
            ++i;
        }
    }

    @Override
    protected int preferredWidth() {
        return this.cols * 18;
    }

    @Override
    protected int preferredHeight() {
        return (int)Math.ceil((double)this.container.m_6643_() / (double)this.cachedCols) * 18;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.TRANSPARENT;
    }
}

