/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.handler;

import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.handler.ItemGuiCreator;
import team.creative.creativecore.common.gui.integration.GuiScreenIntegration;
import team.creative.creativecore.common.gui.packet.OpenGuiPacket;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;

public abstract class GuiCreator {
    public static final NamedHandlerRegistry<GuiCreator> REGISTRY = new NamedHandlerRegistry<Object>(null);
    public static final GuiCreatorItem ITEM_OPENER = GuiCreator.register("item", new GuiCreatorItem());
    String name;
    public final BiFunction<CompoundTag, Player, GuiLayer> function;

    public static <T extends GuiCreator> T register(String name, T creator) {
        creator.name = name;
        REGISTRY.register(name, creator);
        return creator;
    }

    public GuiCreator(BiFunction<CompoundTag, Player, GuiLayer> function) {
        this.function = function;
    }

    public String getName() {
        return this.name;
    }

    protected void openGui(CompoundTag nbt, Player player) {
        if (player.f_19853_.f_46443_) {
            CreativeCore.NETWORK.sendToServer(new OpenGuiPacket(this.name, nbt));
        } else {
            OpenGuiPacket.openGuiOnServer(this, nbt, (ServerPlayer)player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openClientSide(GuiLayer layer) {
        Minecraft.m_91087_().m_91346_((Screen)new GuiScreenIntegration(layer));
    }

    public static class GuiCreatorItem
    extends GuiCreator {
        public GuiCreatorItem() {
            super((nbt, player) -> {
                InteractionHand hand = nbt.m_128471_("main_hand") ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                ItemStack stack = player.m_21120_(hand);
                Item patt2815$temp = stack.m_41720_();
                if (patt2815$temp instanceof ItemGuiCreator) {
                    ItemGuiCreator item = (ItemGuiCreator)patt2815$temp;
                    return item.create((CompoundTag)nbt, (Player)player);
                }
                return null;
            });
        }

        public void open(Player player, InteractionHand hand) {
            this.open(new CompoundTag(), player, hand);
        }

        public void open(CompoundTag nbt, Player player, InteractionHand hand) {
            nbt.m_128379_("main_hand", hand == InteractionHand.MAIN_HAND);
        }
    }

    public static class GuiCreatorBasic
    extends GuiCreator {
        public GuiCreatorBasic(BiFunction<CompoundTag, Player, GuiLayer> function) {
            super(function);
        }

        public void open(Player player) {
            this.openGui(new CompoundTag(), player);
        }

        public void open(CompoundTag nbt, Player player) {
            this.openGui(nbt, player);
        }
    }
}

