/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type.set;

import java.util.Arrays;

public class QuadBitSet {
    private static final int CHUNK_SIZE = 8;
    private long[][] chunks;
    private int minChunkX;
    private int minChunkY;
    private boolean empty = true;

    private static int chunkIndex(int coord) {
        if (coord < 0) {
            return (int)Math.floor((double)coord / 8.0);
        }
        return coord / 8;
    }

    private static int index(int x, int y) {
        return x * 8 + y;
    }

    private void init(int x, int y) {
        int chunkX = QuadBitSet.chunkIndex(x);
        int chunkY = QuadBitSet.chunkIndex(y);
        this.minChunkX = chunkX;
        this.minChunkY = chunkY;
        this.chunks = new long[1][1];
        this.empty = true;
    }

    private void ensureCapacity(int x, int y) {
        if (this.empty) {
            this.init(x, y);
        } else {
            int additional;
            int chunkX = QuadBitSet.chunkIndex(x);
            int chunkY = QuadBitSet.chunkIndex(y);
            if (chunkX < this.minChunkX) {
                additional = this.minChunkX - chunkX;
                long[][] newChunks = new long[additional + this.chunks.length][];
                for (int i = 0; i < this.chunks.length; ++i) {
                    newChunks[additional + i] = this.chunks[i];
                }
                this.chunks = newChunks;
            } else if (chunkX >= this.minChunkX + this.chunks.length) {
                this.chunks = (long[][])Arrays.copyOf(this.chunks, this.chunks.length + chunkX - (this.minChunkX + this.chunks.length) + 1);
            }
            if (chunkY < this.minChunkY) {
                additional = this.minChunkY - chunkY;
                for (int xIndex = 0; xIndex < this.chunks.length; ++xIndex) {
                    long[] yChunks = this.chunks[xIndex];
                    long[] newChunks = new long[additional + yChunks.length];
                    for (int i = 0; i < yChunks.length; ++i) {
                        newChunks[additional + i] = yChunks[i];
                    }
                    this.chunks[xIndex] = newChunks;
                }
            } else {
                int xIndex = chunkX - this.minChunkX;
                if (this.chunks[xIndex] == null || chunkY >= this.chunks[xIndex].length) {
                    this.chunks[xIndex] = Arrays.copyOf(this.chunks[xIndex], this.chunks[xIndex].length + chunkY - (this.minChunkY + this.chunks[xIndex].length) + 1);
                }
            }
        }
    }

    public void flip(int x, int y) {
        this.ensureCapacity(x, y);
        int chunkX = QuadBitSet.chunkIndex(x);
        int chunkY = QuadBitSet.chunkIndex(y);
        int inChunkX = x % 8;
        int inChunkY = y % 8;
        int xOffset = chunkX - this.minChunkX;
        int yOffset = chunkY - this.minChunkY;
        long[] lArray = this.chunks[xOffset];
        int n = yOffset;
        lArray[n] = lArray[n] ^ 1L << QuadBitSet.index(inChunkX, inChunkY);
    }

    public void set(int x, int y) {
        this.ensureCapacity(x, y);
        int chunkX = QuadBitSet.chunkIndex(x);
        int chunkY = QuadBitSet.chunkIndex(y);
        int inChunkX = x % 8;
        int inChunkY = y % 8;
        int xOffset = chunkX - this.minChunkX;
        int yOffset = chunkY - this.minChunkY;
        long[] lArray = this.chunks[xOffset];
        int n = yOffset;
        lArray[n] = lArray[n] | 1L << QuadBitSet.index(inChunkX, inChunkY);
    }

    public void set(int x, int y, boolean value) {
        if (value) {
            this.set(x, y);
        } else {
            this.clear(x, y);
        }
    }

    public void clear(int x, int y) {
        this.ensureCapacity(x, y);
        int chunkX = QuadBitSet.chunkIndex(x);
        int chunkY = QuadBitSet.chunkIndex(y);
        int inChunkX = x % 8;
        int inChunkY = y % 8;
        int xOffset = chunkX - this.minChunkX;
        int yOffset = chunkY - this.minChunkY;
        long[] lArray = this.chunks[xOffset];
        int n = yOffset;
        lArray[n] = lArray[n] & (1L << QuadBitSet.index(inChunkX, inChunkY) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear() {
        this.empty = true;
        this.chunks = null;
        this.minChunkX = 0;
        this.minChunkY = 0;
    }

    public boolean get(int x, int y) {
        int chunkX = QuadBitSet.chunkIndex(x);
        if (this.chunks == null) {
            return false;
        }
        if (chunkX < this.minChunkX || chunkX >= this.minChunkX + this.chunks.length) {
            return false;
        }
        int xOffset = chunkX - this.minChunkX;
        int chunkY = QuadBitSet.chunkIndex(y);
        if (chunkY < this.minChunkY || chunkY >= this.minChunkY + this.chunks[xOffset].length) {
            return false;
        }
        int yOffset = chunkY - this.minChunkY;
        int inChunkX = x % 8;
        int inChunkY = y % 8;
        return (this.chunks[xOffset][yOffset] & 1L << QuadBitSet.index(inChunkX, inChunkY)) != 0L;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("{");
        boolean first = true;
        if (this.chunks != null) {
            for (int i = 0; i < this.chunks.length; ++i) {
                for (int j = 0; j < this.chunks[i].length; ++j) {
                    long word = this.chunks[i][j];
                    if (word == 0L) continue;
                    if (first) {
                        first = false;
                    } else {
                        result.append(", ");
                    }
                    for (int k = 0; k < 64; ++k) {
                        long data = word & (long)(-1 << k);
                        if (data == 0L) continue;
                        int index = k;
                        int x = (this.minChunkX + i) * 8 + index / 8;
                        int y = (this.minChunkY + j) * 8 + index % 8;
                        result.append("(" + x + ", " + y + ")");
                    }
                }
            }
        }
        result.append("}");
        return result.toString();
    }
}

