/*
 * Decompiled with CFR 0.152.
 */
package me.soapsuds.boatiview.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;

public abstract class CustomLangGenerator
implements class_2405 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, String> dataToTranslate = new TreeMap<String, String>();
    private final class_2403 gen;
    private final String modid;
    private final String locale;

    public CustomLangGenerator(class_2403 gen, String modid, String locale) {
        this.gen = gen;
        this.modid = modid;
        this.locale = locale;
    }

    protected abstract void addTranslationKeyAndNames();

    public void method_10319(class_2408 cache) throws IOException {
        this.addTranslationKeyAndNames();
        if (!this.dataToTranslate.isEmpty()) {
            this.save(cache, this.dataToTranslate, this.gen.method_10313().resolve("assets/" + this.modid + "/lang/" + this.locale + ".json"));
        }
    }

    public String method_10321() {
        return "Language Locale: " + this.locale;
    }

    private void save(class_2408 cache, Object object, Path target) throws IOException {
        String data = GSON.toJson(object);
        data = JavaUnicodeEscaper.outsideOf((int)0, (int)127).translate((CharSequence)data);
        String hash = class_2405.field_11280.hashUnencodedChars((CharSequence)data).toString();
        if (!Objects.equals(cache.method_10323(target), hash) || !Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(target, new OpenOption[0]);){
                bufferedwriter.write(data);
            }
        }
        cache.method_10325(target, hash);
    }

    public void add(String key, String value) {
        if (this.dataToTranslate.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }
}

