/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.packets;

import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import shadows.placebo.Placebo;
import shadows.placebo.network.MessageHelper;
import shadows.placebo.network.MessageProvider;
import shadows.placebo.network.PacketDistro;
import shadows.placebo.patreon.TrailsManager;
import shadows.placebo.patreon.WingsManager;

public class PatreonDisableMessage
implements MessageProvider<PatreonDisableMessage> {
    private int type;
    private UUID id;

    public PatreonDisableMessage(int type) {
        this.type = type;
    }

    public PatreonDisableMessage(int type, UUID id) {
        this(type);
        this.id = id;
    }

    @Override
    public void write(PatreonDisableMessage msg, FriendlyByteBuf buf) {
        buf.writeByte(msg.type);
        buf.writeByte(msg.id == null ? 0 : 1);
        if (msg.id != null) {
            buf.m_130077_(msg.id);
        }
    }

    @Override
    public PatreonDisableMessage read(FriendlyByteBuf buf) {
        byte type = buf.readByte();
        if (buf.readByte() == 1) {
            return new PatreonDisableMessage(type, buf.m_130259_());
        }
        return new PatreonDisableMessage(type);
    }

    @Override
    public void handle(PatreonDisableMessage msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            MessageHelper.handlePacket(() -> () -> PatreonDisableMessage.lambda$handle$0(msg, (Supplier)ctx), ctx);
        } else {
            MessageHelper.handlePacket(() -> () -> {
                Set<UUID> set;
                Set<UUID> set2 = set = msg.type == 0 ? TrailsManager.DISABLED : WingsManager.DISABLED;
                if (set.contains(msg.id)) {
                    set.remove(msg.id);
                } else {
                    set.add(msg.id);
                }
            }, ctx);
        }
    }

    private static /* synthetic */ void lambda$handle$0(PatreonDisableMessage msg, Supplier ctx) {
        PacketDistro.sendToAll(Placebo.CHANNEL, new PatreonDisableMessage(msg.type, ((NetworkEvent.Context)ctx.get()).getSender().m_142081_()));
    }
}

