/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public abstract class BlockBreakingKineticTileEntity
extends KineticTileEntity {
    public static final AtomicInteger NEXT_BREAKER_ID = new AtomicInteger();
    protected int ticksUntilNextProgress;
    protected int destroyProgress;
    protected int breakerId = -NEXT_BREAKER_ID.incrementAndGet();
    protected BlockPos breakingPos;

    public BlockBreakingKineticTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.destroyProgress == -1) {
            this.destroyNextTick();
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.ticksUntilNextProgress == -1) {
            this.destroyNextTick();
        }
    }

    public void destroyNextTick() {
        this.ticksUntilNextProgress = 1;
    }

    protected abstract BlockPos getBreakingPos();

    protected boolean shouldRun() {
        return true;
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Progress", this.destroyProgress);
        compound.m_128405_("NextTick", this.ticksUntilNextProgress);
        if (this.breakingPos != null) {
            compound.m_128365_("Breaking", (Tag)NbtUtils.m_129224_((BlockPos)this.breakingPos));
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.destroyProgress = compound.m_128451_("Progress");
        this.ticksUntilNextProgress = compound.m_128451_("NextTick");
        if (compound.m_128441_("Breaking")) {
            this.breakingPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Breaking"));
        }
        super.read(compound, clientPacket);
    }

    @Override
    public void m_7651_() {
        if (!this.f_58857_.f_46443_ && this.destroyProgress != 0) {
            this.f_58857_.m_6801_(this.breakerId, this.breakingPos, -1);
        }
        super.m_7651_();
    }

    @Override
    public void tick() {
        float blockHardness;
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.shouldRun()) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        this.breakingPos = this.getBreakingPos();
        if (this.ticksUntilNextProgress < 0) {
            return;
        }
        if (this.ticksUntilNextProgress-- > 0) {
            return;
        }
        BlockState stateToBreak = this.f_58857_.m_8055_(this.breakingPos);
        if (!this.canBreak(stateToBreak, blockHardness = stateToBreak.m_60800_((BlockGetter)this.f_58857_, this.breakingPos))) {
            if (this.destroyProgress != 0) {
                this.destroyProgress = 0;
                this.f_58857_.m_6801_(this.breakerId, this.breakingPos, -1);
            }
            return;
        }
        float breakSpeed = this.getBreakSpeed();
        this.destroyProgress += Mth.m_14045_((int)((int)(breakSpeed / blockHardness)), (int)1, (int)(10 - this.destroyProgress));
        this.f_58857_.m_5594_(null, this.f_58858_, stateToBreak.m_60827_().m_56778_(), SoundSource.NEUTRAL, 0.25f, 1.0f);
        if (this.destroyProgress >= 10) {
            this.onBlockBroken(stateToBreak);
            this.destroyProgress = 0;
            this.ticksUntilNextProgress = -1;
            this.f_58857_.m_6801_(this.breakerId, this.breakingPos, -1);
            return;
        }
        this.ticksUntilNextProgress = (int)(blockHardness / breakSpeed);
        this.f_58857_.m_6801_(this.breakerId, this.breakingPos, this.destroyProgress);
    }

    public boolean canBreak(BlockState stateToBreak, float blockHardness) {
        return BlockBreakingKineticTileEntity.isBreakable(stateToBreak, blockHardness);
    }

    public static boolean isBreakable(BlockState stateToBreak, float blockHardness) {
        return !stateToBreak.m_60767_().m_76332_() && !(stateToBreak.m_60734_() instanceof AirBlock) && blockHardness != -1.0f;
    }

    public void onBlockBroken(BlockState stateToBreak) {
        FluidState FluidState2 = this.f_58857_.m_6425_(this.breakingPos);
        this.f_58857_.m_46796_(2001, this.breakingPos, Block.m_49956_((BlockState)stateToBreak));
        BlockEntity tileentity = stateToBreak.m_155947_() ? this.f_58857_.m_7702_(this.breakingPos) : null;
        Vec3 vec = VecHelper.offsetRandomly(VecHelper.getCenterOf((Vec3i)this.breakingPos), this.f_58857_.f_46441_, 0.125f);
        Block.m_49869_((BlockState)stateToBreak, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)this.breakingPos, (BlockEntity)tileentity).forEach(stack -> {
            if (!stack.m_41619_() && this.f_58857_.m_46469_().m_46207_(GameRules.f_46136_) && !this.f_58857_.restoringBlockSnapshots) {
                ItemEntity itementity = new ItemEntity(this.f_58857_, vec.f_82479_, vec.f_82480_, vec.f_82481_, stack);
                itementity.m_32060_();
                itementity.m_20256_(Vec3.f_82478_);
                this.f_58857_.m_7967_((Entity)itementity);
            }
        });
        if (this.f_58857_ instanceof ServerLevel) {
            stateToBreak.m_60612_((ServerLevel)this.f_58857_, this.breakingPos, ItemStack.f_41583_);
        }
        this.f_58857_.m_7731_(this.breakingPos, FluidState2.m_76188_(), 3);
    }

    protected float getBreakSpeed() {
        return Math.abs(this.getSpeed() / 100.0f);
    }
}

