/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.chassis;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.AbstractChassisBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LinearChassisBlock
extends AbstractChassisBlock {
    public static final BooleanProperty STICKY_TOP = BooleanProperty.m_61465_((String)"sticky_top");
    public static final BooleanProperty STICKY_BOTTOM = BooleanProperty.m_61465_((String)"sticky_bottom");

    public LinearChassisBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)STICKY_TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)STICKY_BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STICKY_TOP, STICKY_BOTTOM});
        super.m_7926_(builder);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos placedOnPos = context.m_8083_().m_142300_(context.m_43719_().m_122424_());
        BlockState blockState = context.m_43725_().m_8055_(placedOnPos);
        if (context.m_43723_() == null || !context.m_43723_().m_6144_()) {
            if (LinearChassisBlock.isChassis(blockState)) {
                return (BlockState)this.m_49966_().m_61124_((Property)f_55923_, (Comparable)((Direction.Axis)blockState.m_61143_((Property)f_55923_)));
            }
            return (BlockState)this.m_49966_().m_61124_((Property)f_55923_, (Comparable)context.m_7820_().m_122434_());
        }
        return super.m_5573_(context);
    }

    public BlockState m_7417_(BlockState state, Direction side, BlockState other, LevelAccessor p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        BooleanProperty property = this.getGlueableSide(state, side);
        if (property == null || !LinearChassisBlock.sameKind(state, other) || state.m_61143_((Property)f_55923_) != other.m_61143_((Property)f_55923_)) {
            return state;
        }
        return (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BooleanProperty getGlueableSide(BlockState state, Direction face) {
        if (face.m_122434_() != state.m_61143_((Property)f_55923_)) {
            return null;
        }
        return face.m_122421_() == Direction.AxisDirection.POSITIVE ? STICKY_TOP : STICKY_BOTTOM;
    }

    @Override
    protected boolean glueAllowedOnSide(BlockGetter world, BlockPos pos, BlockState state, Direction side) {
        BlockState other = world.m_8055_(pos.m_142300_(side));
        return !LinearChassisBlock.sameKind(other, state) || state.m_61143_((Property)f_55923_) != other.m_61143_((Property)f_55923_);
    }

    public static boolean isChassis(BlockState state) {
        return AllBlocks.LINEAR_CHASSIS.has(state) || AllBlocks.SECONDARY_LINEAR_CHASSIS.has(state);
    }

    public static boolean sameKind(BlockState state1, BlockState state2) {
        return state1.m_60734_() == state2.m_60734_();
    }

    public static class ChassisCTBehaviour
    extends ConnectedTextureBehaviour.Base {
        @Override
        public CTSpriteShiftEntry getShift(BlockState state, Direction direction, @Nullable TextureAtlasSprite sprite) {
            Block block = state.m_60734_();
            BooleanProperty glueableSide = ((LinearChassisBlock)block).getGlueableSide(state, direction);
            if (glueableSide == null) {
                return AllBlocks.LINEAR_CHASSIS.has(state) ? AllSpriteShifts.CHASSIS_SIDE : AllSpriteShifts.SECONDARY_CHASSIS_SIDE;
            }
            return (Boolean)state.m_61143_((Property)glueableSide) != false ? AllSpriteShifts.CHASSIS_STICKY : AllSpriteShifts.CHASSIS;
        }

        @Override
        protected Direction getUpDirection(BlockAndTintGetter reader, BlockPos pos, BlockState state, Direction face) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
            if (face.m_122434_() == axis) {
                return super.getUpDirection(reader, pos, state, face);
            }
            return Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        }

        @Override
        protected Direction getRightDirection(BlockAndTintGetter reader, BlockPos pos, BlockState state, Direction face) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
            return axis != face.m_122434_() && axis.m_122479_() ? (face.m_122434_().m_122479_() ? Direction.DOWN : (axis == Direction.Axis.X ? Direction.NORTH : Direction.EAST)) : super.getRightDirection(reader, pos, state, face);
        }

        @Override
        protected boolean reverseUVsHorizontally(BlockState state, Direction face) {
            boolean side;
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
            boolean bl = side = face.m_122434_() != axis;
            if (side && axis == Direction.Axis.X && face.m_122434_().m_122479_()) {
                return true;
            }
            return super.reverseUVsHorizontally(state, face);
        }

        @Override
        protected boolean reverseUVsVertically(BlockState state, Direction face) {
            return super.reverseUVsVertically(state, face);
        }

        @Override
        public boolean reverseUVs(BlockState state, Direction face) {
            boolean end;
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
            boolean bl = end = face.m_122434_() == axis;
            if (end && axis.m_122479_() && face.m_122421_() == Direction.AxisDirection.POSITIVE) {
                return true;
            }
            if (!end && axis.m_122479_() && face == Direction.DOWN) {
                return true;
            }
            return super.reverseUVs(state, face);
        }

        @Override
        public boolean connectsTo(BlockState state, BlockState other, BlockAndTintGetter reader, BlockPos pos, BlockPos otherPos, Direction face) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
            boolean superConnect = face.m_122434_() == axis ? super.connectsTo(state, other, reader, pos, otherPos, face) : LinearChassisBlock.sameKind(state, other);
            return superConnect && axis == other.m_61143_((Property)RotatedPillarBlock.f_55923_);
        }
    }
}

