/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.edgePoint.signal;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgePointType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingBehaviour;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Couple;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class TrackEdgePoint {
    public UUID id;
    public Couple<TrackNodeLocation> edgeLocation;
    public double position;
    private EdgePointType<?> type;

    public void setId(UUID id) {
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public void setType(EdgePointType<?> type) {
        this.type = type;
    }

    public EdgePointType<?> getType() {
        return this.type;
    }

    public abstract boolean canMerge();

    public boolean canCoexistWith(EdgePointType<?> otherType, boolean front) {
        return false;
    }

    public abstract void invalidate(LevelAccessor var1);

    protected void invalidateAt(LevelAccessor level, BlockPos tilePos) {
        TrackTargetingBehaviour<?> behaviour = TileEntityBehaviour.get((BlockGetter)level, tilePos, TrackTargetingBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        CompoundTag migrationData = new CompoundTag();
        DimensionPalette dimensions = new DimensionPalette();
        this.write(migrationData, dimensions);
        dimensions.write(migrationData);
        behaviour.invalidateEdgePoint(migrationData);
    }

    public abstract void tileAdded(BlockEntity var1, boolean var2);

    public abstract void tileRemoved(BlockPos var1, boolean var2);

    public void onRemoved(TrackGraph graph) {
    }

    public void setLocation(Couple<TrackNodeLocation> nodes, double position) {
        this.edgeLocation = nodes;
        this.position = position;
    }

    public double getLocationOn(TrackEdge edge) {
        return this.isPrimary(edge.node1) ? edge.getLength() - this.position : this.position;
    }

    public boolean canNavigateVia(TrackNode side) {
        return true;
    }

    public boolean isPrimary(TrackNode node1) {
        return ((TrackNodeLocation)((Object)this.edgeLocation.getSecond())).equals((Object)node1.getLocation());
    }

    public void read(CompoundTag nbt, boolean migration, DimensionPalette dimensions) {
        if (migration) {
            return;
        }
        this.id = nbt.m_128342_("Id");
        this.position = nbt.m_128459_("Position");
        this.edgeLocation = Couple.deserializeEach(nbt.m_128437_("Edge", 10), tag -> TrackNodeLocation.read(tag, dimensions));
    }

    public void read(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        this.id = buffer.m_130259_();
        this.edgeLocation = Couple.create(() -> TrackNodeLocation.receive(buffer, dimensions));
        this.position = buffer.readDouble();
    }

    public void write(CompoundTag nbt, DimensionPalette dimensions) {
        nbt.m_128362_("Id", this.id);
        nbt.m_128347_("Position", this.position);
        nbt.m_128365_("Edge", (Tag)this.edgeLocation.serializeEach(loc -> loc.write(dimensions)));
    }

    public void write(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        buffer.m_130085_(this.type.getId());
        buffer.m_130077_(this.id);
        this.edgeLocation.forEach(loc -> loc.send(buffer, dimensions));
        buffer.writeDouble(this.position);
    }

    public void tick(TrackGraph graph, boolean preTrains) {
    }

    protected void removeFromAllGraphs() {
        for (TrackGraph trackGraph : Create.RAILWAYS.trackNetworks.values()) {
            if (trackGraph.removePoint(this.getType(), this.id) == null) continue;
            return;
        }
    }
}

