/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.management.edgePoint.station;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.management.edgePoint.TrackTargetingBehaviour;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Components;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class StationMarker {
    private final BlockPos source;
    private final BlockPos target;
    private final Component name;

    public StationMarker(BlockPos source, BlockPos target, Component name) {
        this.source = source;
        this.target = target;
        this.name = name;
    }

    public static StationMarker load(CompoundTag tag) {
        BlockPos source = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("source"));
        BlockPos target = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("target"));
        MutableComponent name = Component.Serializer.m_130701_((String)tag.m_128461_("name"));
        if (name == null) {
            name = Components.immutableEmpty();
        }
        return new StationMarker(source, target, (Component)name);
    }

    public static StationMarker fromWorld(BlockGetter level, BlockPos pos) {
        Optional stationOption = AllTileEntities.TRACK_STATION.get(level, pos);
        if (stationOption.isEmpty() || ((StationTileEntity)stationOption.get()).getStation() == null) {
            return null;
        }
        String name = ((StationTileEntity)stationOption.get()).getStation().name;
        return new StationMarker(pos, TileEntityBehaviour.get((BlockEntity)stationOption.get(), TrackTargetingBehaviour.TYPE).getPositionForMapMarker(), (Component)Components.literal(name));
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("source", (Tag)NbtUtils.m_129224_((BlockPos)this.source));
        tag.m_128365_("target", (Tag)NbtUtils.m_129224_((BlockPos)this.target));
        tag.m_128359_("name", Component.Serializer.m_130703_((Component)this.name));
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StationMarker that = (StationMarker)o;
        if (!this.target.equals((Object)that.target)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.name);
    }

    public BlockPos getTarget() {
        return this.target;
    }

    public BlockPos getSource() {
        return this.source;
    }

    public Component getName() {
        return this.name;
    }

    public MapDecoration.Type getType() {
        return MapDecoration.Type.MANSION;
    }

    public String getId() {
        return "create:station-" + this.target.m_123341_() + "," + this.target.m_123342_() + "," + this.target.m_123343_();
    }

    public static class Decoration
    extends MapDecoration {
        public Decoration(byte pX, byte pY, Component pName) {
            super(MapDecoration.Type.MANSION, pX, pY, (byte)0, pName);
        }

        public boolean m_77809_() {
            return true;
        }

        public boolean render(int index) {
            return true;
        }

        public boolean render(PoseStack ms, MultiBufferSource bufferSource, int mapId, MapItemSavedData mapData, boolean active, int packedLight, int index) {
            ms.m_85836_();
            ms.m_85837_((double)this.m_77804_() / 2.0 + 64.0, (double)this.m_77805_() / 2.0 + 64.0, -0.02);
            ms.m_85836_();
            ms.m_85837_(0.5, 0.0, 0.0);
            ms.m_85841_(4.5f, 4.5f, 3.0f);
            VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110497_((ResourceLocation)Create.asResource("textures/gui/station_map_icon.png")));
            float zOffset = -0.001f;
            float alpha = 1.0f;
            Matrix4f mat = ms.m_85850_().m_85861_();
            buffer.m_85982_(mat, -1.0f, -1.0f, zOffset * (float)index).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 0.0f).m_85969_(packedLight).m_5752_();
            buffer.m_85982_(mat, -1.0f, 1.0f, zOffset * (float)index).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 1.0f).m_85969_(packedLight).m_5752_();
            buffer.m_85982_(mat, 1.0f, 1.0f, zOffset * (float)index).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 1.0f).m_85969_(packedLight).m_5752_();
            buffer.m_85982_(mat, 1.0f, -1.0f, zOffset * (float)index).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 0.0f).m_85969_(packedLight).m_5752_();
            ms.m_85849_();
            if (this.m_77810_() != null) {
                Font font = Minecraft.m_91087_().f_91062_;
                Component component = this.m_77810_();
                float f6 = font.m_92852_((FormattedText)component);
                ms.m_85836_();
                ms.m_85837_(0.0, 6.0, (double)-0.005f);
                ms.m_85841_(0.8f, 0.8f, 1.0f);
                ms.m_85837_((double)(-f6 / 2.0f + 0.5f), 0.0, 0.0);
                font.m_92841_(component, 0.0f, 0.0f, -1, false, ms.m_85850_().m_85861_(), bufferSource, false, Integer.MIN_VALUE, 0xF000F0);
                ms.m_85849_();
            }
            ms.m_85849_();
            return false;
        }
    }
}

