/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.mixin;

import com.google.common.collect.Maps;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationMapData;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationMarker;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MapItemSavedData.class})
public class MapItemSavedDataMixin
implements StationMapData {
    @Final
    @Shadow
    public int f_77885_;
    @Final
    @Shadow
    public int f_77886_;
    @Final
    @Shadow
    public byte f_77890_;
    @Final
    @Shadow
    Map<String, MapDecoration> f_77894_;
    private final Map<String, StationMarker> stationMarkers = Maps.newLinkedHashMap();

    @Inject(method={"save(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="RETURN")})
    public void save(CompoundTag compound, CallbackInfoReturnable<CompoundTag> cir) {
        ListTag listTag = new ListTag();
        for (StationMarker stationMarker : this.stationMarkers.values()) {
            listTag.add((Object)stationMarker.save());
        }
        ((CompoundTag)cir.getReturnValue()).m_128365_("create:stations", (Tag)listTag);
    }

    @Inject(method={"load(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/world/level/saveddata/maps/MapItemSavedData;"}, at={@At(value="RETURN")})
    private static void load(CompoundTag compound, CallbackInfoReturnable<MapItemSavedData> cir) {
        MapItemSavedData mapData = (MapItemSavedData)cir.getReturnValue();
        StationMapData stationMapData = (StationMapData)mapData;
        ListTag listTag = compound.m_128437_("create:stations", 10);
        for (int k = 0; k < listTag.size(); ++k) {
            StationMarker stationMarker = StationMarker.load(listTag.m_128728_(k));
            stationMapData.addStationMarker(stationMarker);
        }
    }

    @Override
    public void addStationMarker(StationMarker marker) {
        this.stationMarkers.put(marker.getId(), marker);
        int scaleMultiplier = 1 << this.f_77890_;
        double localX = ((double)marker.getTarget().m_123341_() - (double)this.f_77885_) / (double)scaleMultiplier;
        double localZ = ((double)marker.getTarget().m_123343_() - (double)this.f_77886_) / (double)scaleMultiplier;
        if (localX < -63.0 || localX > 63.0 || localZ < -63.0 || localZ > 63.0) {
            return;
        }
        byte localXByte = (byte)(localX * 2.0 + 0.5);
        byte localZByte = (byte)(localZ * 2.0 + 0.5);
        StationMarker.Decoration decoration = new StationMarker.Decoration(localXByte, localZByte, marker.getName());
        this.f_77894_.put(marker.getId(), decoration);
    }

    @Shadow
    private void m_164799_(String pIdentifier) {
        throw new AssertionError();
    }

    @Shadow
    public boolean m_181312_(int pTrackedCount) {
        throw new AssertionError();
    }

    @Override
    public boolean toggleStation(LevelAccessor level, BlockPos pos, StationTileEntity stationTileEntity) {
        double xCenter = (double)pos.m_123341_() + 0.5;
        double zCenter = (double)pos.m_123343_() + 0.5;
        int scaleMultiplier = 1 << this.f_77890_;
        double localX = (xCenter - (double)this.f_77885_) / (double)scaleMultiplier;
        double localZ = (zCenter - (double)this.f_77886_) / (double)scaleMultiplier;
        if (localX < -63.0 || localX > 63.0 || localZ < -63.0 || localZ > 63.0) {
            return false;
        }
        StationMarker marker = StationMarker.fromWorld((BlockGetter)level, pos);
        if (marker == null) {
            return false;
        }
        if (this.stationMarkers.remove(marker.getId(), marker)) {
            this.m_164799_(marker.getId());
            return true;
        }
        if (!this.m_181312_(256)) {
            this.addStationMarker(marker);
        }
        return false;
    }

    @Inject(method={"checkBanners(Lnet/minecraft/world/level/BlockGetter;II)V"}, at={@At(value="RETURN")})
    public void checkBanners(BlockGetter pReader, int pX, int pZ, CallbackInfo ci) {
        this.checkStations(pReader, pX, pZ);
    }

    private void checkStations(BlockGetter pReader, int pX, int pZ) {
        Iterator<StationMarker> iterator = this.stationMarkers.values().iterator();
        while (iterator.hasNext()) {
            StationMarker other;
            StationMarker marker = iterator.next();
            if (marker.getTarget().m_123341_() != pX || marker.getTarget().m_123343_() != pZ || marker.equals(other = StationMarker.fromWorld(pReader, marker.getSource()))) continue;
            iterator.remove();
            this.m_164799_(marker.getId());
            if (other == null || !marker.getTarget().equals((Object)other.getTarget())) continue;
            this.addStationMarker(other);
        }
    }
}

