/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.utility.Lang;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.nbt.CompoundTag;

public class FilesHelper {
    public static void createFolderIfMissing(String name) {
        try {
            Files.createDirectories(Paths.get(name, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            Create.LOGGER.warn("Could not create Folder: {}", (Object)name);
        }
    }

    public static String findFirstValidFilename(String name, String folderPath, String extension) {
        String filename;
        String filepath;
        int index = 0;
        do {
            filename = FilesHelper.slug(name) + (String)(index == 0 ? "" : "_" + index) + "." + extension;
            ++index;
        } while (Files.exists(Paths.get(filepath = folderPath + "/" + filename, new String[0]), new LinkOption[0]));
        return filename;
    }

    public static String slug(String name) {
        return Lang.asId(name).replaceAll("\\W+", "_");
    }

    public static boolean saveTagCompoundAsJson(CompoundTag compound, String path) {
        try {
            Files.deleteIfExists(Paths.get(path, new String[0]));
            JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(Paths.get(path, new String[0]), StandardOpenOption.CREATE));
            writer.setIndent("  ");
            Streams.write((JsonElement)JsonParser.parseString((String)compound.toString()), (JsonWriter)writer);
            writer.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean saveTagCompoundAsJsonCompact(CompoundTag compound, String path) {
        try {
            Files.deleteIfExists(Paths.get(path, new String[0]));
            JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(Paths.get(path, new String[0]), StandardOpenOption.CREATE));
            Streams.write((JsonElement)JsonParser.parseString((String)compound.toString()), (JsonWriter)writer);
            writer.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static JsonElement loadJson(InputStream inputStream) {
        try {
            JsonReader reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader(inputStream)));
            reader.setLenient(true);
            JsonElement element = Streams.parse((JsonReader)reader);
            reader.close();
            inputStream.close();
            return element;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JsonElement loadJsonResource(String filepath) {
        return FilesHelper.loadJson(ClassLoader.getSystemResourceAsStream(filepath));
    }

    public static JsonElement loadJson(String filepath) {
        try {
            return FilesHelper.loadJson(Files.newInputStream(Paths.get(filepath, new String[0]), StandardOpenOption.READ));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

