/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.block_set;

import java.util.EnumMap;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.selene.blocks.VerticalSlabBlock;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class BlockRegistryHelper {
    public static EnumMap<VariantType, RegistryObject<Block>> registerFullBlockSet(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry, String baseName, Block parentBlock, boolean isHidden) {
        EnumMap<VariantType, RegistryObject<Block>> map = new EnumMap<VariantType, RegistryObject<Block>>(VariantType.class);
        for (VariantType type : VariantType.values()) {
            Object name = baseName;
            if (!type.equals((Object)VariantType.BLOCK)) {
                name = (String)name + "_" + type.name().toLowerCase(Locale.ROOT);
            }
            RegistryObject block = blockRegistry.register((String)name, () -> type.create(parentBlock));
            CreativeModeTab tab = switch (type) {
                case VariantType.VERTICAL_SLAB -> {
                    if (!isHidden && ModList.get().isLoaded("quark")) {
                        yield CreativeModeTab.f_40749_;
                    }
                    yield null;
                }
                case VariantType.WALL -> {
                    if (!isHidden) {
                        yield CreativeModeTab.f_40750_;
                    }
                    yield null;
                }
                default -> !isHidden ? CreativeModeTab.f_40749_ : null;
            };
            itemRegistry.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
            map.put(type, (RegistryObject<Block>)block);
        }
        return map;
    }

    public static enum VariantType {
        BLOCK(Block::new),
        SLAB(SlabBlock::new),
        VERTICAL_SLAB(VerticalSlabBlock::new),
        WALL(WallBlock::new),
        STAIRS(StairBlock::new);

        private final BiFunction<Supplier<BlockState>, BlockBehaviour.Properties, Block> constructor;

        private VariantType(BiFunction<Supplier<BlockState>, BlockBehaviour.Properties, Block> constructor) {
            this.constructor = constructor;
        }

        private VariantType(Function<BlockBehaviour.Properties, Block> constructor) {
            this.constructor = (b, p) -> (Block)constructor.apply((BlockBehaviour.Properties)p);
        }

        private Block create(Block parent) {
            return this.constructor.apply(() -> ((Block)parent).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)parent));
        }
    }
}

