/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.map.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.map.CustomMapDecoration;
import net.mehvahdjukaar.selene.map.markers.GenericMapBlockMarker;
import net.mehvahdjukaar.selene.map.type.IMapDecorationType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import org.jetbrains.annotations.Nullable;

public class SimpleDecorationType
implements IMapDecorationType<CustomMapDecoration, GenericMapBlockMarker<CustomMapDecoration>> {
    private final ResourceLocation id;
    @Nullable
    private final RuleTest target;
    public static final Codec<SimpleDecorationType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(SimpleDecorationType::getId), (App)RuleTest.f_74307_.optionalFieldOf("target_block").forGetter(SimpleDecorationType::getTarget)).apply((Applicative)instance, SimpleDecorationType::new));

    public SimpleDecorationType(ResourceLocation id, Optional<RuleTest> target) {
        this.id = id;
        this.target = target.orElse(null);
    }

    @Nullable
    public Optional<RuleTest> getTarget() {
        return Optional.ofNullable(this.target);
    }

    @Override
    public boolean hasMarker() {
        return this.target != null;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    public String toString() {
        return this.getId().toString();
    }

    @Override
    @Nullable
    public CustomMapDecoration loadDecorationFromBuffer(FriendlyByteBuf buffer) {
        try {
            return new CustomMapDecoration(this, buffer);
        }
        catch (Exception e) {
            Selene.LOGGER.warn("Failed to load custom map decoration for decoration type" + this.getId() + ": " + e);
            return null;
        }
    }

    @Override
    @Nullable
    public GenericMapBlockMarker<CustomMapDecoration> loadMarkerFromNBT(CompoundTag compound) {
        if (this.hasMarker()) {
            GenericMapBlockMarker<CustomMapDecoration> marker = new GenericMapBlockMarker<CustomMapDecoration>(this);
            try {
                marker.loadFromNBT(compound);
                return marker;
            }
            catch (Exception e) {
                Selene.LOGGER.warn("Failed to load world map marker for decoration type" + this.getId() + ": " + e);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public GenericMapBlockMarker<CustomMapDecoration> getWorldMarkerFromWorld(BlockGetter reader, BlockPos pos) {
        if (this.target != null && this.target.m_7715_(reader.m_8055_(pos), new Random(0L))) {
            return new GenericMapBlockMarker<CustomMapDecoration>(this, pos);
        }
        return null;
    }
}

