/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.mehvahdjukaar.selene.Selene;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class StaticResource {
    public final byte[] data;
    public final ResourceLocation location;
    public final String sourceName;

    private StaticResource(byte[] data, ResourceLocation location, String sourceName) {
        this.data = data;
        this.location = location;
        this.sourceName = sourceName;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public static StaticResource of(Resource original) {
        byte[] data1;
        try {
            data1 = original.m_6679_().readAllBytes();
        }
        catch (IOException e) {
            data1 = new byte[]{};
            Selene.LOGGER.error("Could not parse resource: {}", (Object)original.m_7843_());
        }
        finally {
            try {
                original.close();
            }
            catch (IOException iOException) {}
        }
        return new StaticResource(data1, original.m_7843_(), original.m_7816_());
    }

    public static StaticResource create(byte[] data, ResourceLocation location) {
        return new StaticResource(data, location, location.toString());
    }

    @Nullable
    public static StaticResource getOrLog(ResourceManager manager, ResourceLocation location) {
        try {
            return StaticResource.of(manager.m_142591_(location));
        }
        catch (Exception var4) {
            Selene.LOGGER.error("Could not find resource {}", (Object)location);
            return null;
        }
    }

    public static StaticResource getOrFail(ResourceManager manager, ResourceLocation location) throws IOException {
        return StaticResource.of(manager.m_142591_(location));
    }
}

