/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.rendering.CARenderType;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class WireNodeRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final float HANG = 0.5f;

    public WireNodeRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void m_6922_(T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combindOverlayIn) {
        IWireNode te = (IWireNode)tileEntityIn;
        for (int i = 0; i < te.getNodeCount(); ++i) {
            if (te.getNodeType(i) == null) continue;
            Vec3 d1 = te.getNodeOffset(i);
            float ox1 = (float)d1.m_7096_();
            float oy1 = (float)d1.m_7098_();
            float oz1 = (float)d1.m_7094_();
            IWireNode wn = te.getNode(i);
            if (wn == null) {
                return;
            }
            Vec3 d2 = wn.getNodeOffset(te.getOtherNodeIndex(i));
            float ox2 = (float)d2.m_7096_();
            float oy2 = (float)d2.m_7098_();
            float oz2 = (float)d2.m_7094_();
            BlockPos other = te.getNodePos(i);
            float tx = other.m_123341_() - te.getMyPos().m_123341_();
            float ty = other.m_123342_() - te.getMyPos().m_123342_();
            float tz = other.m_123343_() - te.getMyPos().m_123343_();
            matrixStackIn.m_85836_();
            float dis = WireNodeRenderer.distanceFromZero(tx, ty, tz);
            matrixStackIn.m_85837_((double)(tx + 0.5f + ox2), (double)(ty + 0.5f + oy2), (double)(tz + 0.5f + oz2));
            WireNodeRenderer.wireRender(tileEntityIn, other, matrixStackIn, bufferIn, -tx - ox2 + ox1, -ty - oy2 + oy1, -tz - oz2 + oz1, te.getNodeType(i), dis);
            matrixStackIn.m_85849_();
        }
    }

    private static float divf(int a, int b) {
        return (float)a / (float)b;
    }

    private static float hang(float f, float dis) {
        return (float)Math.sin(-f * (float)Math.PI) * (0.5f * dis / (float)IWireNode.MAX_LENGTH);
    }

    public static float distanceFromZero(float x, float y, float z) {
        return (float)Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
    }

    public static void wireRender(BlockEntity tileEntityIn, BlockPos other, PoseStack matrix, MultiBufferSource buffer, float x, float y, float z, WireType type, float dis) {
        VertexConsumer ivertexbuilder = buffer.m_6299_(CARenderType.WIRE);
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        float f = Mth.m_14195_((float)(x * x + z * z)) * 0.025f / 2.0f;
        float o1 = z * f;
        float o2 = x * f;
        BlockPos blockpos1 = tileEntityIn.m_58899_();
        BlockPos blockpos2 = other;
        int i = tileEntityIn.m_58904_().m_45517_(LightLayer.BLOCK, blockpos1);
        int j = tileEntityIn.m_58904_().m_45517_(LightLayer.BLOCK, blockpos2);
        int k = tileEntityIn.m_58904_().m_45517_(LightLayer.SKY, blockpos1);
        int l = tileEntityIn.m_58904_().m_45517_(LightLayer.SKY, blockpos2);
        WireNodeRenderer.wirePart(ivertexbuilder, matrix4f, x, y, z, j, i, l, k, 0.025f, 0.025f, o1, o2, type, dis);
        WireNodeRenderer.wirePart(ivertexbuilder, matrix4f, x, y, z, j, i, l, k, 0.025f, 0.0f, o1, o2, type, dis);
    }

    public static void wirePart(VertexConsumer vertBuilder, Matrix4f matrix, float x, float y, float z, int l1, int l2, int l3, int l4, float a, float b, float o1, float o2, WireType type, float dis) {
        for (int j = 0; j < 24; ++j) {
            float f = (float)j / 23.0f;
            int k = (int)Mth.m_14179_((float)f, (float)l1, (float)l2);
            int l = (int)Mth.m_14179_((float)f, (float)l3, (float)l4);
            int light = LightTexture.m_109885_((int)k, (int)l);
            WireNodeRenderer.wireVert(vertBuilder, matrix, light, x, y, z, a, b, 24, j, false, o1, o2, type, dis);
            WireNodeRenderer.wireVert(vertBuilder, matrix, light, x, y, z, a, b, 24, j + 1, true, o1, o2, type, dis);
        }
    }

    public static void wireVert(VertexConsumer vertBuilder, Matrix4f matrix, int light, float x, float y, float z, float a, float b, int count, int index, boolean sw, float o1, float o2, WireType type, float dis) {
        int cr = type.getRed();
        int cg = type.getGreen();
        int cb = type.getBlue();
        if (index % 2 == 0) {
            cr = (int)((float)cr * 0.7f);
            cg = (int)((float)cg * 0.7f);
            cb = (int)((float)cb * 0.7f);
        }
        float part = (float)index / (float)count;
        float fx = x * part;
        float fy = (y > 0.0f ? y * part * part : y - y * (1.0f - part) * (1.0f - part)) + WireNodeRenderer.hang(WireNodeRenderer.divf(index, count), dis);
        float fz = z * part;
        if (Math.abs(x) + Math.abs(z) < Math.abs(y)) {
            boolean p = b > 0.0f;
            float c = 0.015f;
            if (!sw) {
                vertBuilder.m_85982_(matrix, fx - c, fy, fz + (p ? -c : c)).m_6122_(cr, cg, cb, 255).m_85969_(light).m_5752_();
            }
            vertBuilder.m_85982_(matrix, fx + c, fy, fz + (p ? c : -c)).m_6122_(cr, cg, cb, 255).m_85969_(light).m_5752_();
            if (sw) {
                vertBuilder.m_85982_(matrix, fx - c, fy, fz + (p ? -c : c)).m_6122_(cr, cg, cb, 255).m_85969_(light).m_5752_();
            }
        } else {
            if (!sw) {
                vertBuilder.m_85982_(matrix, fx + o1, fy + a - b, fz - o2).m_6122_(cr, cg, cb, 255).m_85969_(light).m_5752_();
            }
            vertBuilder.m_85982_(matrix, fx - o1, fy + b, fz + o2).m_6122_(cr, cg, cb, 255).m_85969_(light).m_5752_();
            if (sw) {
                vertBuilder.m_85982_(matrix, fx + o1, fy + a - b, fz - o2).m_6122_(cr, cg, cb, 255).m_85969_(light).m_5752_();
            }
        }
    }
}

