/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.create.behaviors;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.CommonUtil;
import net.mehvahdjukaar.supplementaries.integration.create.behaviors.MovementUtils;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BambooSpikesBehavior
implements MovementBehaviour {
    private static final BambooSpikesBlockTile DUMMY = new BambooSpikesBlockTile(BlockPos.f_121853_, ((Block)ModRegistry.BAMBOO_SPIKES.get()).m_49966_());

    public boolean isSameDir(MovementContext context) {
        return VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)((Direction)context.state.m_61143_((Property)BambooSpikesBlock.FACING)));
    }

    public boolean renderAsNormalTileEntity() {
        return true;
    }

    public void tick(MovementContext context) {
        this.damageEntities(context);
    }

    public void damageEntities(MovementContext context) {
        Level world = context.world;
        Vec3 pos = context.position;
        DamageSource damageSource = this.getDamageSource();
        block0: for (Entity entity2 : world.m_45976_(Entity.class, new AABB(pos.m_82520_(-0.5, -0.5, -0.5), pos.m_82520_(0.5, 0.5, 0.5)))) {
            Object player;
            if (entity2 instanceof ItemEntity || entity2 instanceof AbstractContraptionEntity || entity2 instanceof Player && (player = (Player)entity2).m_7500_()) continue;
            if (entity2 instanceof AbstractMinecart) {
                player = entity2.m_146897_().iterator();
                while (player.hasNext()) {
                    Entity passenger = (Entity)player.next();
                    if (!(passenger instanceof AbstractContraptionEntity) || ((AbstractContraptionEntity)passenger).getContraption() != context.contraption) continue;
                    continue block0;
                }
            }
            if (entity2.m_6084_() && entity2 instanceof LivingEntity && !world.f_46443_) {
                double pow = 5.0 * Math.pow(context.relativeMotion.m_82553_(), 0.4) + 1.0;
                float damage = !this.isSameDir(context) ? 1.0f : (float)Mth.m_14008_((double)pow, (double)2.0, (double)6.0);
                entity2.m_6469_(damageSource, damage);
                this.doTileStuff(context, world, (LivingEntity)entity2);
            }
            if (world.f_46443_ != entity2 instanceof Player) continue;
            Vec3 motionBoost = context.motion.m_82520_(0.0, context.motion.m_82553_() / 4.0, 0.0);
            int maxBoost = 4;
            if (motionBoost.m_82553_() > (double)maxBoost) {
                motionBoost = motionBoost.m_82546_(motionBoost.m_82541_().m_82490_(motionBoost.m_82553_() - (double)maxBoost));
            }
            entity2.m_20256_(entity2.m_20184_().m_82549_(motionBoost));
            entity2.f_19864_ = true;
        }
    }

    private void doTileStuff(MovementContext context, @Nonnull Level world, LivingEntity le) {
        CompoundTag com = context.tileData;
        long lastTicked = com.m_128454_("LastTicked");
        if (!this.isOnCooldown(world, lastTicked)) {
            DUMMY.m_142466_(com);
            if (DUMMY.interactWithEntity(le, world)) {
                MovementUtils.changeState(context, (BlockState)context.state.m_61124_((Property)BambooSpikesBlock.TIPPED, (Comparable)Boolean.valueOf(false)));
            }
            com = DUMMY.m_187480_();
            lastTicked = world.m_46467_();
            com.m_128356_("LastTicked", lastTicked);
            context.tileData = com;
        }
    }

    public boolean isOnCooldown(Level world, long lastTicked) {
        return world.m_46467_() - lastTicked < 20L;
    }

    protected DamageSource getDamageSource() {
        return CommonUtil.SPIKE_DAMAGE;
    }
}

