/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.create.behaviors;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import java.util.function.UnaryOperator;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.HourGlassBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.blocks.HourGlassBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.HourGlassBlockTile;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HourglassBehavior
implements MovementBehaviour {
    public void tick(MovementContext context) {
        UnaryOperator rot = context.rotation;
        BlockState state = context.state;
        Direction dir = (Direction)state.m_61143_((Property)HourGlassBlock.FACING);
        Vec3i in = dir.m_122436_();
        Vec3 v = new Vec3((double)in.m_123341_(), (double)in.m_123342_(), (double)in.m_123343_());
        Vec3 v2 = (Vec3)rot.apply(v);
        double dot = v2.m_82526_(new Vec3(0.0, 1.0, 0.0));
        CompoundTag com = context.tileData;
        HourGlassBlockTile.HourGlassSandType sandType = HourGlassBlockTile.HourGlassSandType.values()[com.m_128451_("SandType")];
        float progress = com.m_128457_("Progress");
        float prevProgress = com.m_128457_("PrevProgress");
        if (!sandType.isEmpty()) {
            prevProgress = progress;
            if (dot > 0.0 && progress != 1.0f) {
                progress = Math.min(progress + sandType.increment, 1.0f);
            } else if (dot < 0.0 && progress != 0.0f) {
                progress = Math.max(progress - sandType.increment, 0.0f);
            }
        }
        com.m_128473_("Progress");
        com.m_128473_("PrevProgress");
        com.m_128350_("Progress", progress);
        com.m_128350_("PrevProgress", prevProgress);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        CompoundTag com = context.tileData;
        HourGlassBlockTile.HourGlassSandType sandType = HourGlassBlockTile.HourGlassSandType.values()[com.m_128451_("SandType")];
        float progress = com.m_128457_("Progress");
        float prevProgress = com.m_128457_("PrevProgress");
        NonNullList stacks = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)com, (NonNullList)stacks);
        float partialTicks = 1.0f;
        if (sandType.isEmpty()) {
            return;
        }
        Vec3 v = context.position;
        if (v == null) {
            v = new Vec3(0.0, 0.0, 0.0);
        }
        BlockPos pos = new BlockPos(v);
        int light = LevelRenderer.m_109541_((BlockAndTintGetter)context.world, (BlockPos)pos);
        TextureAtlasSprite sprite = sandType.getSprite((ItemStack)stacks.get(0), (Level)renderWorld);
        float h = Mth.m_14179_((float)partialTicks, (float)prevProgress, (float)progress);
        Direction dir = (Direction)context.state.m_61143_((Property)HourGlassBlock.FACING);
        HourGlassBlockTileRenderer.renderSand(matrices.getModelViewProjection(), buffer, light, 0, sprite, h, dir);
    }
}

