/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.wire.LevelAccess;
import alternate.current.wire.WireBlock;
import alternate.current.wire.WireHandler;
import alternate.current.wire.WireNode;
import alternate.current.wire.WireType;
import java.util.Arrays;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class Node {
    private static final int CONDUCTOR = 1;
    private static final int SOURCE = 2;
    final LevelAccess level;
    final Node[] neighbors;
    class_2338 pos;
    class_2680 state;
    boolean invalid;
    private int flags;

    Node(LevelAccess level) {
        this.level = level;
        this.neighbors = new Node[WireHandler.Directions.ALL.length];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node node = (Node)obj;
        return this.level == node.level && this.pos.equals((Object)node.pos);
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    Node update(class_2338 pos, class_2680 state, boolean clearNeighbors) {
        if (state.method_26204() instanceof WireBlock) {
            throw new IllegalStateException("Cannot update a regular Node to a WireNode!");
        }
        if (clearNeighbors) {
            Arrays.fill(this.neighbors, null);
        }
        this.pos = pos.method_10062();
        this.state = state;
        this.invalid = false;
        this.flags = 0;
        if (this.level.isConductor(this.pos, this.state)) {
            this.flags |= 1;
        }
        if (this.state.method_26219()) {
            this.flags |= 2;
        }
        return this;
    }

    public boolean isWire() {
        return false;
    }

    public boolean isWire(WireType type) {
        return false;
    }

    public boolean isConductor() {
        return (this.flags & 1) != 0;
    }

    public boolean isSignalSource() {
        return (this.flags & 2) != 0;
    }

    public WireNode asWire() {
        throw new UnsupportedOperationException("Not a WireNode!");
    }
}

