/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.minimap.Effect;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec2;

public class HudOverlayHandler {
    private static final String DEBUG_PREFIX = ChatFormatting.AQUA + "[JM] " + ChatFormatting.RESET;
    private static final String DEBUG_SUFFIX = "";
    private final Minecraft mc = Minecraft.m_91087_();
    private long statTimerCheck;
    private List<String> statTimerReport = Collections.EMPTY_LIST;

    public boolean preOverlay(PoseStack poseStack) {
        if (!Minecraft.m_91087_().f_91066_.f_92062_ && Effect.getInstance().canPotionShift()) {
            Vec2 location = Effect.getInstance().getPotionEffectsLocation();
            poseStack.m_85836_();
            poseStack.m_85837_((double)location.f_82470_, (double)location.f_82471_, 0.0);
            return true;
        }
        return false;
    }

    public void postOverlay(PoseStack poseStack) {
        poseStack.m_85849_();
    }

    public void onRenderOverlayDebug(List<String> leftText) {
        try {
            if (this.mc.f_91066_.f_92063_ && !"off".equalsIgnoreCase(JourneymapClient.getInstance().getCoreProperties().logLevel.get())) {
                leftText.add(null);
                if (JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                    for (String line : MapPlayerTask.getDebugStats()) {
                        leftText.add(DEBUG_PREFIX + line);
                    }
                } else {
                    leftText.add(Constants.getString("jm.common.enable_mapping_false_text"));
                }
                if (this.mc.f_91066_.f_92064_) {
                    if (System.currentTimeMillis() - this.statTimerCheck > 3000L) {
                        this.statTimerReport = StatTimer.getReportByTotalTime(DEBUG_PREFIX, DEBUG_SUFFIX);
                        this.statTimerCheck = System.currentTimeMillis();
                    }
                    leftText.add(null);
                    leftText.addAll(this.statTimerReport);
                }
            }
        }
        catch (Throwable t) {
            JMLogger.logOnce("Unexpected error during onRenderOverlayEarly: " + t, t);
        }
    }

    public void onRenderOverlay(PoseStack poseStack) {
        try {
            UIManager.INSTANCE.drawMiniMap(poseStack);
        }
        catch (Throwable t) {
            JMLogger.logOnce("Unexpected error during onRenderOverlayEarly: " + t, t);
        }
    }
}

