/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import journeymap.client.api.display.Context;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.model.EntityDTO;
import journeymap.common.helper.DimensionHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class MapType {
    public final Integer vSlice;
    public final Name name;
    public final ResourceKey<Level> dimension;
    public final Context.MapType apiMapType;
    private final int theHashCode;
    private final String theCacheKey;

    public MapType(Name name, Integer vSlice, ResourceKey<Level> dimension) {
        vSlice = name != Name.underground ? null : vSlice;
        this.name = name;
        this.vSlice = vSlice;
        this.dimension = dimension;
        this.apiMapType = this.toApiContextMapType(name);
        this.theCacheKey = MapType.toCacheKey(name, vSlice, dimension);
        this.theHashCode = this.theCacheKey.hashCode();
    }

    public static MapType from(Name name, Integer vSlice, ResourceKey<Level> dimension) {
        return DataCache.INSTANCE.getMapType(name, vSlice, dimension);
    }

    public static MapType from(Integer vSlice, ResourceKey<Level> dimension) {
        return MapType.from(vSlice == null ? Name.surface : Name.underground, vSlice, dimension);
    }

    public static MapType from(Name name, EntityDTO player) {
        return MapType.from(name, player.chunkCoordY, player.dimension);
    }

    public static MapType day(ResourceKey<Level> dimension) {
        return MapType.from(Name.day, null, dimension);
    }

    public static MapType day(EntityDTO player) {
        return MapType.from(Name.day, null, player.dimension);
    }

    public static MapType night(ResourceKey<Level> dimension) {
        return MapType.from(Name.night, null, dimension);
    }

    public static MapType night(EntityDTO player) {
        return MapType.from(Name.night, null, player.dimension);
    }

    public static MapType topo(ResourceKey<Level> dimension) {
        return MapType.from(Name.topo, null, dimension);
    }

    public static MapType topo(EntityDTO player) {
        return MapType.from(Name.topo, null, player.dimension);
    }

    public static MapType underground(EntityDTO player) {
        return MapType.from(Name.underground, player.chunkCoordY, player.dimension);
    }

    public static MapType biome(EntityDTO player) {
        return MapType.from(Name.biome, null, player.dimension);
    }

    public static MapType biome(ResourceKey<Level> dimension) {
        return MapType.from(Name.biome, null, dimension);
    }

    public static MapType underground(Integer vSlice, ResourceKey<Level> dimension) {
        return MapType.from(Name.underground, vSlice, dimension);
    }

    public static MapType none() {
        return MapType.from(Name.none, 0, (ResourceKey<Level>)Level.f_46428_);
    }

    public static String toCacheKey(Name name, Integer vSlice, ResourceKey<Level> dimension) {
        return String.format("%s|%s|%s", new Object[]{DimensionHelper.getDimName(dimension), name, vSlice == null ? "_" : vSlice});
    }

    private Context.MapType toApiContextMapType(Name name) {
        return switch (name) {
            case Name.day -> Context.MapType.Day;
            case Name.topo -> Context.MapType.Topo;
            case Name.night -> Context.MapType.Night;
            case Name.underground -> Context.MapType.Underground;
            case Name.biome -> Context.MapType.Biome;
            default -> Context.MapType.Any;
        };
    }

    public static MapType fromApiContextMapType(Context.MapType apiMapType, Integer vSlice, ResourceKey<Level> dimension) {
        switch (apiMapType) {
            case Night: {
                return new MapType(Name.night, vSlice, dimension);
            }
            case Underground: {
                return new MapType(Name.underground, vSlice, dimension);
            }
            case Topo: {
                return new MapType(Name.topo, vSlice, dimension);
            }
            case Biome: {
                return new MapType(Name.biome, vSlice, dimension);
            }
        }
        return new MapType(Name.day, vSlice, dimension);
    }

    public String toCacheKey() {
        return this.theCacheKey;
    }

    public String toString() {
        return this.theCacheKey;
    }

    public String name() {
        return this.name.name();
    }

    public boolean isUnderground() {
        return this.name == Name.underground;
    }

    public boolean isSurface() {
        return this.name == Name.surface;
    }

    public boolean isSurfaceType() {
        return this.name == Name.surface || this.name == Name.day || this.name == Name.night || this.name == Name.topo || this.name == Name.biome;
    }

    public boolean isDay() {
        return this.name == Name.day;
    }

    public boolean isNight() {
        return this.name == Name.night;
    }

    public boolean isTopo() {
        return this.name == Name.topo;
    }

    public boolean isBiome() {
        return this.name == Name.biome;
    }

    public boolean isDayOrNight() {
        return this.name == Name.day || this.name == Name.night;
    }

    public boolean isAllowed() {
        if (this.isUnderground()) {
            return FeatureManager.getInstance().isAllowed(Feature.MapCaves);
        }
        if (this.isTopo()) {
            return FeatureManager.getInstance().isAllowed(Feature.MapTopo);
        }
        if (this.isDayOrNight() || this.isSurface()) {
            return FeatureManager.getInstance().isAllowed(Feature.MapSurface);
        }
        if (this.isBiome()) {
            return FeatureManager.getInstance().isAllowed(Feature.MapBiome);
        }
        return this.name == Name.none;
    }

    public int hashCode() {
        return this.theHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapType mapType = (MapType)o;
        if (this.dimension != mapType.dimension) {
            return false;
        }
        if (this.name != mapType.name) {
            return false;
        }
        return !(this.vSlice != null ? !this.vSlice.equals(mapType.vSlice) : mapType.vSlice != null);
    }

    public static enum Name {
        day,
        night,
        underground,
        surface,
        topo,
        biome,
        none;

    }
}

