/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.NativeImage;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.accessor.HttpTextureAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.accessor.SkullSettings;
import dev.tr7zw.skinlayers.render.CustomizableModelPart;
import dev.tr7zw.skinlayers.render.SolidPixelWrapper;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class SkinUtil {
    private static NativeImage getSkinTexture(AbstractClientPlayer player) {
        return SkinUtil.getTexture(player.m_108560_());
    }

    private static NativeImage getTexture(ResourceLocation resourceLocation) {
        try {
            if (Minecraft.m_91087_().m_91098_().m_7165_(resourceLocation)) {
                Resource resource = Minecraft.m_91087_().m_91098_().m_142591_(resourceLocation);
                NativeImage skin = NativeImage.m_85058_((InputStream)resource.m_6679_());
                return skin;
            }
            AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(resourceLocation);
            if (texture instanceof HttpTextureAccessor) {
                HttpTextureAccessor httpTexture = (HttpTextureAccessor)texture;
                try {
                    return httpTexture.getImage();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            SkinLayersModBase.LOGGER.warn("Unable to handle skin " + resourceLocation + ". Potentially a conflict with another mod.");
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setup3dLayers(AbstractClientPlayer abstractClientPlayerEntity, PlayerSettings settings, boolean thinArms, PlayerModel<AbstractClientPlayer> model) {
        ResourceLocation skinLocation = abstractClientPlayerEntity.m_108560_();
        if (skinLocation == null) {
            return false;
        }
        if (skinLocation.equals((Object)settings.getCurrentSkin()) && thinArms == settings.hasThinArms()) {
            return settings.getSkinLayers() != null;
        }
        try (NativeImage skin = SkinUtil.getSkinTexture(abstractClientPlayerEntity);){
            if (skin == null || skin.m_84982_() != 64 || skin.m_85084_() != 64) {
                settings.setCurrentSkin(skinLocation);
                settings.setThinArms(thinArms);
                settings.setupHeadLayers(null);
                settings.setupSkinLayers(null);
                boolean bl = false;
                return bl;
            }
            CustomizableModelPart[] layers = new CustomizableModelPart[5];
            layers[0] = SolidPixelWrapper.wrapBox(skin, 4, 12, 4, 0, 48, true, 0.0f);
            layers[1] = SolidPixelWrapper.wrapBox(skin, 4, 12, 4, 0, 32, true, 0.0f);
            if (thinArms) {
                layers[2] = SolidPixelWrapper.wrapBox(skin, 3, 12, 4, 48, 48, true, -2.5f);
                layers[3] = SolidPixelWrapper.wrapBox(skin, 3, 12, 4, 40, 32, true, -2.5f);
            } else {
                layers[2] = SolidPixelWrapper.wrapBox(skin, 4, 12, 4, 48, 48, true, -2.5f);
                layers[3] = SolidPixelWrapper.wrapBox(skin, 4, 12, 4, 40, 32, true, -2.5f);
            }
            layers[4] = SolidPixelWrapper.wrapBox(skin, 8, 12, 4, 16, 32, true, -0.8f);
            settings.setupSkinLayers(layers);
            settings.setupHeadLayers(SolidPixelWrapper.wrapBox(skin, 8, 8, 8, 32, 0, false, 0.6f));
            settings.setCurrentSkin(skinLocation);
            settings.setThinArms(thinArms);
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setup3dLayers(GameProfile gameprofile, SkullSettings settings) {
        if (gameprofile == null) {
            return false;
        }
        Map map = Minecraft.m_91087_().m_91109_().m_118815_(gameprofile);
        MinecraftProfileTexture texture = (MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN);
        if (texture == null) {
            return false;
        }
        ResourceLocation resourceLocation = Minecraft.m_91087_().m_91109_().m_118825_(texture, MinecraftProfileTexture.Type.SKIN);
        try (NativeImage skin = SkinUtil.getTexture(resourceLocation);){
            if (skin == null || skin.m_84982_() != 64 || skin.m_85084_() != 64) {
                boolean bl = false;
                return bl;
            }
            settings.setupHeadLayers(SolidPixelWrapper.wrapBox(skin, 8, 8, 8, 32, 0, false, 0.6f));
            boolean bl = true;
            return bl;
        }
    }
}

