/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.harvester;

import com.ewyboy.quickharvest.api.Harvester;
import com.ewyboy.quickharvest.config.Config;
import com.ewyboy.quickharvest.config.HarvesterConfig;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;

public abstract class AbstractHarvester
extends Harvester {
    private final HarvesterConfig config;

    protected AbstractHarvester() {
        this(Config.DEFAULT);
    }

    protected AbstractHarvester(HarvesterConfig config) {
        this.config = config;
    }

    @Override
    public boolean canHarvest(Player player, InteractionHand hand, ServerLevel world, BlockPos pos, BlockState state, Direction side) {
        return this.isEffectiveOn(state) && this.canPlayerEdit(player, hand, world, pos, state, side) && !this.isHoldingBlacklistedItem(player, hand) && !this.isTryingToBuild(player, hand, world, pos) && (!this.requiresTool() || player.m_21205_().m_41735_(state));
    }

    @Override
    public boolean isTryingToBuild(Player player, InteractionHand hand, ServerLevel level, BlockPos pos) {
        return player.m_21120_(hand).m_150930_(level.m_8055_(pos).m_60734_().m_5456_());
    }

    @Override
    public boolean isHoldingBlacklistedItem(Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        return this.config.getBlacklist().contains(heldStack.m_41720_());
    }

    @Override
    public boolean canPlayerEdit(Player player, InteractionHand hand, ServerLevel world, BlockPos pos, BlockState state, Direction side) {
        return world.m_46749_(pos) && world.m_7966_(player, pos);
    }

    @Override
    public boolean enabled() {
        return this.config.isEnabled();
    }

    @Override
    public boolean requiresTool() {
        return this.config.requiresTool();
    }

    @Override
    public ToolAction requiredTool() {
        return this.config.getToolType();
    }

    @Override
    protected boolean takesReplantItem() {
        return this.config.takesReplantItem();
    }

    @Override
    public Predicate<ItemStack> replantItem() {
        return stack -> stack.m_41720_() == this.config.getReplantItem();
    }

    protected void damageTool(Player playerEntity, InteractionHand hand, int amount) {
        if (!this.requiresTool()) {
            return;
        }
        playerEntity.m_21120_(hand).m_41622_(amount, (LivingEntity)playerEntity, it -> it.m_21190_(hand));
    }

    protected void takeReplantItem(List<ItemStack> drops) {
        if (!this.takesReplantItem()) {
            return;
        }
        Predicate<ItemStack> replantPredicate = this.replantItem();
        for (ItemStack drop : drops) {
            if (!replantPredicate.test(drop)) continue;
            drop.m_41774_(1);
            return;
        }
    }
}

