/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.harvester;

import com.ewyboy.quickharvest.config.HarvesterConfig;
import com.ewyboy.quickharvest.harvester.AbstractHarvester;
import com.ewyboy.quickharvest.util.FloodFill;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class KelpHarvester
extends AbstractHarvester {
    private static final Predicate<BlockState> IS_KELP_BLOCK = s -> s.m_60734_() == Blocks.f_50576_;
    private static final Predicate<BlockState> IS_KELP_TOP = s -> s.m_60734_() == Blocks.f_50575_;
    private static final Predicate<BlockState> KELP = IS_KELP_BLOCK.or(IS_KELP_TOP);

    public KelpHarvester(HarvesterConfig config) {
        super(config);
    }

    @Override
    public List<ItemStack> harvest(Player player, InteractionHand hand, ServerLevel world, BlockPos pos, BlockState state, Direction side) {
        FloodFill floodFill = new FloodFill(pos, kelpMe -> {
            Direction[] directionArray;
            if (KELP.test((BlockState)kelpMe)) {
                Direction[] directionArray2 = new Direction[2];
                directionArray2[0] = Direction.UP;
                directionArray = directionArray2;
                directionArray2[1] = Direction.DOWN;
            } else {
                directionArray = FloodFill.NO_DIRECTIONS;
            }
            return directionArray;
        }, (Set<Predicate<BlockState>>)ImmutableSet.of(KELP));
        floodFill.search(world);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Set<BlockInWorld> kelpBlocks = floodFill.getFoundTargets().get(KELP);
        for (BlockInWorld info : kelpBlocks) {
            if (info.m_61176_().equals((Object)floodFill.getLowestPoint())) continue;
            info.m_61168_();
            drops.addAll(Block.m_49869_((BlockState)info.m_61168_(), (ServerLevel)world, (BlockPos)info.m_61176_(), (BlockEntity)info.m_61174_()));
            world.m_46961_(info.m_61176_(), false);
        }
        this.damageTool(player, hand, kelpBlocks.size() - 1);
        this.takeReplantItem(drops);
        return drops;
    }

    @Override
    protected boolean isEffectiveOn(BlockState state) {
        return KELP.test(state);
    }
}

