/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.setup;

import com.ewyboy.quickharvest.QuickHarvest;
import com.ewyboy.quickharvest.api.Harvester;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="quickharvest")
public class ForgeEventHandlers {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getUseBlock() == Event.Result.DENY || event.getUseItem() == Event.Result.DENY) {
            return;
        }
        Level rawWorld = event.getWorld();
        if (!(rawWorld instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)rawWorld;
        Player player = event.getPlayer();
        if (player.m_20089_() == Pose.CROUCHING) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = world.m_8055_(pos);
        InteractionHand hand = event.getHand();
        Direction side = event.getFace();
        for (Harvester harvester : QuickHarvest.Registries.HARVESTERS.getValues()) {
            if (!harvester.enabled() || !harvester.canHarvest(player, hand, world, pos, state, side)) continue;
            harvester.harvest(player, hand, world, pos, state, side).forEach(stack -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack));
            player.m_21011_(hand, true);
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
            event.setCanceled(true);
            break;
        }
    }
}

