/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.quickharvest.util;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class FloodFill {
    public static final Direction[] NO_DIRECTIONS = new Direction[0];
    private final Function<BlockState, Iterable<Direction>> stateSearchMapper;
    private final Map<Predicate<BlockState>, Set<BlockInWorld>> foundTargets;
    private final Deque<BlockPos> toVisit;
    private final Set<BlockPos> visited;
    private BlockPos lowestPoint;
    private BlockPos highestPoint;

    public FloodFill(BlockPos origin, Function<BlockState, Direction[]> stateSearchMapper, Set<Predicate<BlockState>> targets) {
        this.lowestPoint = origin.m_7949_();
        this.highestPoint = origin.m_7949_();
        this.stateSearchMapper = s -> Arrays.asList((Direction[])stateSearchMapper.apply((BlockState)s));
        this.foundTargets = new HashMap<Predicate<BlockState>, Set<BlockInWorld>>();
        targets.forEach(target -> this.foundTargets.put((Predicate<BlockState>)target, new HashSet()));
        this.visited = new HashSet<BlockPos>();
        this.toVisit = new ArrayDeque<BlockPos>(){

            @Override
            public void push(BlockPos pos) {
                if (FloodFill.this.visited.add(pos)) {
                    super.push(pos);
                }
            }
        };
        this.toVisit.push(origin);
    }

    public void search(ServerLevel world) {
        while (!this.toVisit.isEmpty()) {
            BlockPos pos = this.toVisit.pollLast();
            BlockInWorld blockInfo = new BlockInWorld((LevelReader)world, pos, false);
            BlockState blockState = blockInfo.m_61168_();
            if (blockState == null) continue;
            this.stateSearchMapper.apply(blockState).forEach(it -> this.toVisit.push(pos.m_142300_(it)));
            this.foundTargets.entrySet().stream().filter(it -> ((Predicate)it.getKey()).test(blockState)).forEach(it -> ((Set)it.getValue()).add(blockInfo));
            if (!this.foundTargets.keySet().stream().anyMatch(it -> it.test(blockState))) continue;
            if (pos.m_123342_() < this.lowestPoint.m_123342_()) {
                this.lowestPoint = pos.m_7949_();
                continue;
            }
            if (pos.m_123342_() <= this.highestPoint.m_123342_()) continue;
            this.highestPoint = pos.m_7949_();
        }
    }

    public Map<Predicate<BlockState>, Set<BlockInWorld>> getFoundTargets() {
        return this.foundTargets;
    }

    public BlockPos getLowestPoint() {
        return this.lowestPoint;
    }

    public BlockPos getHighestPoint() {
        return this.highestPoint;
    }

    public FloodFill add(FloodFill other) {
        if (other.highestPoint.m_123342_() > this.highestPoint.m_123342_()) {
            this.highestPoint = other.highestPoint;
        }
        if (other.lowestPoint.m_123342_() < this.lowestPoint.m_123342_()) {
            this.lowestPoint = other.lowestPoint;
        }
        this.visited.addAll(other.visited);
        other.getFoundTargets().forEach((key, value) -> this.foundTargets.computeIfAbsent((Predicate<BlockState>)key, $ -> new HashSet()).addAll(value));
        return this;
    }
}

