/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.config.ClientConfig;
import fuzs.visualworkbench.world.level.block.entity.CraftingTableBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class WorkbenchTileEntityRenderer
implements BlockEntityRenderer<CraftingTableBlockEntity> {
    private final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();

    public WorkbenchTileEntityRenderer(BlockEntityRendererProvider.Context pContext) {
    }

    public void render(CraftingTableBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        for (int i = 0; i < tileEntityIn.m_6643_(); ++i) {
            ItemStack itemStack = tileEntityIn.m_8020_(i);
            if (itemStack == ItemStack.f_41583_) continue;
            matrixStackIn.m_85836_();
            if (((ClientConfig)VisualWorkbench.CONFIG.client()).flatRendering) {
                this.renderLaying(tileEntityIn, partialTicks, matrixStackIn, itemStack, i);
            } else {
                this.renderFloating(tileEntityIn, partialTicks, matrixStackIn, itemStack, i);
            }
            Minecraft.m_91087_().m_91291_().m_174269_(itemStack, ItemTransforms.TransformType.FIXED, tileEntityIn.combinedLight, combinedOverlayIn, matrixStackIn, bufferIn, (int)tileEntityIn.m_58899_().m_121878_() + i);
            matrixStackIn.m_85849_();
        }
    }

    private void renderFloating(CraftingTableBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, ItemStack itemStack, int index) {
        float shift = (float)Math.abs(((double)((float)tileEntityIn.ticks + partialTicks) * 50.0 + (double)((long)index * 1000L)) % 5000.0 - 2500.0) / 200000.0f;
        BakedModel ibakedmodel = this.itemRenderer.m_174264_(itemStack, null, null, 0);
        boolean isBlockItem = ibakedmodel.m_7539_();
        float scale = isBlockItem ? 0.24f : 0.18f;
        matrixStackIn.m_85837_(0.5, (double)shift, 0.5);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)tileEntityIn.currentAngle, (float)tileEntityIn.nextAngle)));
        matrixStackIn.m_85837_((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, 1.09375, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
        matrixStackIn.m_85841_(scale, scale, scale);
    }

    private void renderLaying(CraftingTableBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, ItemStack itemStack, int index) {
        BakedModel ibakedmodel = this.itemRenderer.m_174264_(itemStack, null, null, 0);
        boolean isBlockItem = ibakedmodel.m_7539_();
        float scale = isBlockItem ? 0.25f : 0.175f;
        matrixStackIn.m_85837_(0.5, 0.0, 0.5);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14179_((float)partialTicks, (float)tileEntityIn.currentAngle, (float)tileEntityIn.nextAngle)));
        matrixStackIn.m_85837_((double)(index % 3) * 3.0 / 16.0 + 0.3125 - 0.5, isBlockItem ? 1.0625 : 1.005, (double)(index / 3) * 3.0 / 16.0 + 0.3125 - 0.5);
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStackIn.m_85841_(scale, scale, scale);
    }
}

