/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.module;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.addons.oddities.client.screen.BackpackInventoryScreen;
import vazkii.quark.addons.oddities.inventory.BackpackMenu;
import vazkii.quark.addons.oddities.item.BackpackItem;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.oddities.HandleBackpackMessage;

@LoadModule(category=ModuleCategory.ODDITIES, hasSubscriptions=true)
public class BackpackModule
extends QuarkModule {
    @Config(description="Set this to true to allow the backpacks to be unequipped even with items in them")
    public static boolean superOpMode = false;
    @Config(flag="ravager_hide")
    public static boolean enableRavagerHide = true;
    @Config
    public static boolean itemsInBackpackTick = true;
    @Config
    public static int baseRavagerHideDrop = 1;
    @Config
    public static double extraChancePerLooting = 0.5;
    public static Item backpack;
    public static Item ravager_hide;
    public static Block bonded_ravager_hide;
    public static MenuType<BackpackMenu> menyType;
    private static ItemStack heldStack;
    @OnlyIn(value=Dist.CLIENT)
    private static boolean backpackRequested;

    @Override
    public void register() {
        backpack = new BackpackItem(this);
        ravager_hide = new QuarkItem("ravager_hide", this, new Item.Properties().m_41497_(Rarity.RARE).m_41491_(CreativeModeTab.f_40759_)).setCondition(() -> enableRavagerHide);
        menyType = IForgeMenuType.create(BackpackMenu::fromNetwork);
        RegistryHelper.register(menyType, (String)"backpack");
        bonded_ravager_hide = new QuarkBlock("bonded_ravager_hide", this, CreativeModeTab.f_40749_, BlockBehaviour.Properties.m_60941_((Material)Material.f_76272_, (DyeColor)DyeColor.BLACK).m_60978_(1.0f).m_60918_(SoundType.f_56745_)).setCondition(() -> enableRavagerHide);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        MenuScreens.m_96206_(menyType, BackpackInventoryScreen::new);
        this.enqueue(() -> ItemProperties.register((Item)backpack, (ResourceLocation)new ResourceLocation("has_items"), (stack, world, entity, i) -> !superOpMode && BackpackItem.doesBackpackHaveItems(stack) ? 1.0f : 0.0f));
    }

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (enableRavagerHide && entity.m_6095_() == EntityType.f_20518_) {
            int amount = baseRavagerHideDrop;
            double chance = (double)event.getLootingLevel() * extraChancePerLooting;
            while (chance > (double)baseRavagerHideDrop) {
                chance -= 1.0;
                ++amount;
            }
            if (chance > 0.0 && entity.f_19853_.f_46441_.nextDouble() < chance) {
                ++amount;
            }
            event.getDrops().add(new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), new ItemStack((ItemLike)ravager_hide, amount)));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onOpenGUI(ScreenOpenEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && BackpackModule.isInventoryGUI(event.getScreen()) && !player.m_150110_().f_35937_ && BackpackModule.isEntityWearingBackpack((Entity)player)) {
            this.requestBackpack();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (BackpackModule.isInventoryGUI(mc.f_91080_) && !backpackRequested && BackpackModule.isEntityWearingBackpack((Entity)mc.f_91074_)) {
            this.requestBackpack();
            mc.f_91074_.f_36095_.m_142503_(mc.f_91074_.m_6844_(EquipmentSlot.CHEST));
            backpackRequested = true;
        } else if (mc.f_91080_ instanceof BackpackInventoryScreen) {
            if (heldStack != null) {
                mc.f_91074_.f_36095_.m_142503_(heldStack);
                heldStack = null;
            }
            backpackRequested = false;
        }
    }

    private void requestBackpack() {
        heldStack = Minecraft.m_91087_().f_91074_.f_36095_.m_142621_();
        QuarkNetwork.sendToServer(new HandleBackpackMessage(true));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void removeCurseTooltip(ItemTooltipEvent event) {
        if (!superOpMode && event.getItemStack().m_41720_() instanceof BackpackItem) {
            for (Component s : event.getToolTip()) {
                if (!s.getString().equals(Enchantments.f_44975_.m_44700_(1).getString())) continue;
                event.getToolTip().remove(s);
                return;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean isInventoryGUI(Screen gui) {
        return gui != null && gui.getClass() == InventoryScreen.class;
    }

    public static boolean isEntityWearingBackpack(Entity e) {
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            ItemStack chestArmor = living.m_6844_(EquipmentSlot.CHEST);
            return chestArmor.m_41720_() instanceof BackpackItem;
        }
        return false;
    }

    public static boolean isEntityWearingBackpack(Entity e, ItemStack stack) {
        if (e instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)e;
            ItemStack chestArmor = living.m_6844_(EquipmentSlot.CHEST);
            return chestArmor == stack;
        }
        return false;
    }

    static {
        heldStack = null;
    }
}

