/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.block;

import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.block.QuarkPaneBlock;
import vazkii.quark.base.handler.RenderLayerHandler;

public class QuarkInheritedPaneBlock
extends QuarkPaneBlock
implements IQuarkBlock,
IBlockColorProvider {
    public final IQuarkBlock parent;

    public QuarkInheritedPaneBlock(IQuarkBlock parent, String name, BlockBehaviour.Properties properties) {
        super(name, parent.getModule(), properties, null);
        this.parent = parent;
        RenderLayerHandler.setInherited((Block)this, parent.getBlock());
    }

    public QuarkInheritedPaneBlock(IQuarkBlock parent, BlockBehaviour.Properties properties) {
        this(parent, parent.getBlock().getRegistryName() + "_pane", properties);
    }

    public QuarkInheritedPaneBlock(IQuarkBlock parent) {
        this(parent, BlockBehaviour.Properties.m_60926_((BlockBehaviour)parent.getBlock()));
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.parent.isEnabled();
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        return this.parent.getBlock().getBeaconColorMultiplier(this.parent.getBlock().m_49966_(), world, pos, beaconPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockColor getBlockColor() {
        return this.parent instanceof IBlockColorProvider ? ((IBlockColorProvider)this.parent).getBlockColor() : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        return this.parent instanceof IItemColorProvider ? ((IItemColorProvider)this.parent).getItemColor() : null;
    }
}

