/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.render;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import vazkii.quark.base.client.handler.ModelHandler;
import vazkii.quark.base.item.boat.QuarkBoat;

public class QuarkBoatRenderer
extends EntityRenderer<QuarkBoat> {
    private final Map<String, Pair<ResourceLocation, BoatModel>> boatResources;

    public QuarkBoatRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = QuarkBoatRenderer.computeBoatResources(context);
    }

    private static Map<String, Pair<ResourceLocation, BoatModel>> computeBoatResources(EntityRendererProvider.Context context) {
        return (Map)QuarkBoat.boatTypes().collect(ImmutableMap.toImmutableMap((Function)Functions.identity(), name -> {
            ResourceLocation texture = new ResourceLocation("quark", "textures/model/entity/boat/" + name + ".png");
            BoatModel model = new BoatModel(context.m_174023_(ModelHandler.quark_boat));
            return Pair.of((Object)texture, (Object)model);
        }));
    }

    public void render(QuarkBoat boat, float yaw, float partialTicks, PoseStack matrix, @Nonnull MultiBufferSource buffer, int light) {
        float f2;
        matrix.m_85836_();
        matrix.m_85837_(0.0, 0.375, 0.0);
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
        float wiggleAngle = (float)boat.m_38385_() - partialTicks;
        float wiggleMagnitude = boat.m_38384_() - partialTicks;
        if (wiggleMagnitude < 0.0f) {
            wiggleMagnitude = 0.0f;
        }
        if (wiggleAngle > 0.0f) {
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)wiggleAngle) * wiggleAngle * wiggleMagnitude / 10.0f * (float)boat.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = boat.m_38352_(partialTicks)), (float)0.0f)) {
            matrix.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), boat.m_38352_(partialTicks), true));
        }
        Pair<ResourceLocation, BoatModel> pair = this.getModelWithLocation(boat);
        ResourceLocation loc = (ResourceLocation)pair.getFirst();
        BoatModel model = (BoatModel)pair.getSecond();
        matrix.m_85841_(-1.0f, -1.0f, 1.0f);
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        model.m_6973_((Boat)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.m_6299_(model.m_103119_(loc));
        model.m_7695_(matrix, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.m_5842_()) {
            VertexConsumer waterMask = buffer.m_6299_(RenderType.m_110478_());
            model.m_102282_().m_104301_(matrix, waterMask, light, OverlayTexture.f_118083_);
        }
        matrix.m_85849_();
        super.m_7392_((Entity)boat, yaw, partialTicks, matrix, buffer, light);
    }

    @Nonnull
    @Deprecated
    public ResourceLocation getTextureLocation(@Nonnull QuarkBoat boat) {
        return (ResourceLocation)this.getModelWithLocation(boat).getFirst();
    }

    public Pair<ResourceLocation, BoatModel> getModelWithLocation(QuarkBoat boat) {
        return this.boatResources.get(boat.getQuarkBoatType());
    }
}

