/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="quark")
public final class ToolInteractionHandler {
    private static final Map<Block, Block> cleanToWaxMap = HashBiMap.create();
    private static final Map<ToolAction, Map<Block, Block>> interactionMaps = new HashMap<ToolAction, Map<Block, Block>>();

    public static void registerWaxedBlock(Block clean, Block waxed) {
        cleanToWaxMap.put(clean, waxed);
        ToolInteractionHandler.registerInteraction(ToolActions.AXE_WAX_OFF, waxed, clean);
    }

    public static void registerInteraction(ToolAction action, Block in, Block out) {
        if (!interactionMaps.containsKey(action)) {
            interactionMaps.put(action, new HashMap());
        }
        Map<Block, Block> map = interactionMaps.get(action);
        map.put(in, out);
    }

    @SubscribeEvent
    public static void toolActionEvent(BlockEvent.BlockToolInteractEvent event) {
        BlockState state;
        Block block;
        Map<Block, Block> map;
        ToolAction action = event.getToolAction();
        if (interactionMaps.containsKey(action) && (map = interactionMaps.get(action)).containsKey(block = (state = event.getState()).m_60734_())) {
            Block finalBlock = map.get(block);
            event.setFinalState(ToolInteractionHandler.copyState(state, finalBlock));
        }
    }

    @SubscribeEvent
    public static void itemUse(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() == Items.f_42784_) {
            BlockPos pos = event.getPos();
            Level world = event.getWorld();
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (cleanToWaxMap.containsKey(block)) {
                Block alternate = cleanToWaxMap.get(block);
                if (!world.f_46443_) {
                    world.m_46597_(pos, ToolInteractionHandler.copyState(state, alternate));
                }
                world.m_5898_(event.getPlayer(), 3003, pos, 0);
                if (!event.getPlayer().m_150110_().f_35937_) {
                    stack.m_41764_(stack.m_41613_() - 1);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    private static BlockState copyState(BlockState original, Block newBlock) {
        BlockState retState = newBlock.m_49966_();
        for (Property prop : original.m_61147_()) {
            if (!retState.m_61138_(prop)) continue;
            retState = (BlockState)retState.m_61124_(prop, original.m_61143_(prop));
        }
        return retState;
    }
}

