/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config.type;

import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.AbstractConfigType;

public class OrePocketConfig
extends AbstractConfigType {
    @Config
    @Config.Min(value=-64.0)
    @Config.Max(value=320.0)
    private int minHeight;
    @Config
    @Config.Min(value=-64.0)
    @Config.Max(value=320.0)
    private int maxHeight;
    @Config
    @Config.Min(value=0.0)
    public int clusterSize;
    @Config(description="Can be a positive integer or a fractional value betweeen 0 and 1. If integer, it spawns that many clusters. If fractional, it has that chance to spawn a single cluster. Set exactly zero to not spawn at all.")
    @Config.Min(value=0.0)
    public double clusterCount;

    public OrePocketConfig(int minHeight, int maxHeight, int clusterSize, double clusterCount) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.clusterSize = clusterSize;
        this.clusterCount = clusterCount;
    }

    public int getRandomHeight(Random rand) {
        return this.minHeight + rand.nextInt(this.maxHeight - this.minHeight);
    }

    public void forEach(BlockPos chunkCorner, Random rand, Consumer<BlockPos> callback) {
        if (this.clusterCount < 1.0 && this.clusterCount > 0.0) {
            this.clusterCount = rand.nextDouble() < this.clusterCount ? 1 : 0;
        }
        int i = 0;
        while ((double)i < this.clusterCount) {
            int x = chunkCorner.m_123341_() + rand.nextInt(16);
            int y = this.getRandomHeight(rand);
            int z = chunkCorner.m_123343_() + rand.nextInt(16);
            callback.accept(new BlockPos(x, y, z));
            ++i;
        }
    }
}

