/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import java.util.List;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class GrabChickensModule
extends QuarkModule {
    @Config
    private static boolean needsNoHelmet = true;
    @Config(description="Set to 0 to disable")
    private static int slownessLevel = 1;
    private static boolean staticEnabled;

    @Override
    public void configChanged() {
        staticEnabled = this.enabled;
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent.EntityInteract event) {
        Entity target = event.getTarget();
        Player player = event.getPlayer();
        Level level = event.getWorld();
        if (staticEnabled && event.getHand() == InteractionHand.MAIN_HAND && !player.m_6047_() && this.canPlayerHostChicken(player) && target.m_6095_() == EntityType.f_20555_) {
            List passengers = player.m_20197_();
            boolean changed = false;
            if (passengers.contains(target)) {
                if (!level.f_46443_) {
                    target.m_8127_();
                }
                changed = true;
            } else if (passengers.isEmpty()) {
                if (!level.f_46443_) {
                    target.m_7998_((Entity)player, false);
                }
                changed = true;
            }
            if (changed) {
                if (level instanceof ServerLevel) {
                    ServerLevel slevel = (ServerLevel)level;
                    slevel.m_7726_().f_8325_.m_140201_(target, (Packet)new ClientboundSetPassengersPacket((Entity)player));
                } else {
                    player.m_6674_(InteractionHand.MAIN_HAND);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.f_19853_;
        if (player.m_146862_(e -> e.m_6095_() == EntityType.f_20555_)) {
            if (!this.canPlayerHostChicken(player)) {
                player.m_20153_();
                if (level instanceof ServerLevel) {
                    ServerLevel slevel = (ServerLevel)level;
                    slevel.m_7726_().f_8325_.m_140201_((Entity)player, (Packet)new ClientboundSetPassengersPacket((Entity)player));
                }
            } else if (!player.m_21023_(MobEffects.f_19591_)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 5, 0, true, false));
                if (slownessLevel > 0 && !player.m_21023_(MobEffects.f_19597_)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, slownessLevel - 1, true, false));
                }
            }
        }
    }

    private boolean canPlayerHostChicken(Player player) {
        return !needsNoHelmet || player.m_6844_(EquipmentSlot.HEAD).m_41619_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setRenderChickenFeetStatus(Chicken entity, ChickenModel<Chicken> model) {
        boolean should;
        if (!staticEnabled) {
            return;
        }
        model.f_170486_.f_104207_ = should = entity.m_20202_() == null || entity.m_20202_().m_6095_() != EntityType.f_20532_;
        model.f_170485_.f_104207_ = should;
    }
}

