/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.module;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.CompoundBiomeConfig;
import vazkii.quark.content.world.gen.structure.BigDungeonStructure;
import vazkii.quark.content.world.gen.structure.processor.BigDungeonChestProcessor;
import vazkii.quark.content.world.gen.structure.processor.BigDungeonSpawnerProcessor;
import vazkii.quark.content.world.gen.structure.processor.BigDungeonWaterProcessor;

@LoadModule(category=ModuleCategory.WORLD, hasSubscriptions=true)
public class BigDungeonModule
extends QuarkModule {
    @Config(description="The chance that a big dungeon spawn candidate will be allowed to spawn. 0.2 is 20%, which is the same as the Pillager Outpost.")
    public static double spawnChance = 0.1;
    @Config
    public static String lootTable = "minecraft:chests/simple_dungeon";
    @Config
    public static int maxRooms = 10;
    @Config
    public static int minStartY = -40;
    @Config
    public static int maxStartY = -20;
    @Config
    public static double chestChance = 0.5;
    @Config
    public static CompoundBiomeConfig biomeConfig = CompoundBiomeConfig.fromBiomeTypes(true, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END);
    private static BigDungeonChestProcessor CHEST_PROCESSOR = new BigDungeonChestProcessor();
    private static BigDungeonSpawnerProcessor SPAWN_PROCESSOR = new BigDungeonSpawnerProcessor();
    private static BigDungeonWaterProcessor WATER_PROCESSOR = new BigDungeonWaterProcessor();
    public static StructureProcessorType<BigDungeonChestProcessor> CHEST_PROCESSOR_TYPE = () -> Codec.unit((Object)((Object)CHEST_PROCESSOR));
    public static StructureProcessorType<BigDungeonSpawnerProcessor> SPAWN_PROCESSOR_TYPE = () -> Codec.unit((Object)((Object)SPAWN_PROCESSOR));
    public static StructureProcessorType<BigDungeonWaterProcessor> WATER_PROCESSOR_TYPE = () -> Codec.unit((Object)((Object)WATER_PROCESSOR));
    public static final DeferredRegister<StructureFeature<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"quark");
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> STRUCTURE = DEFERRED_REGISTRY_STRUCTURE.register("mega_dungeon", () -> new BigDungeonStructure((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));

    @Override
    public void construct() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DEFERRED_REGISTRY_STRUCTURE.register(modEventBus);
    }

    @Override
    public void setup() {
        this.enqueue(this::setupStructures);
    }

    private void setupStructures() {
        BigDungeonModule.registerProcessor("big_dungeon_chest", CHEST_PROCESSOR, CHEST_PROCESSOR_TYPE);
        BigDungeonModule.registerProcessor("big_dungeon_spawner", SPAWN_PROCESSOR, SPAWN_PROCESSOR_TYPE);
        BigDungeonModule.registerProcessor("big_dungeon_water", WATER_PROCESSOR, WATER_PROCESSOR_TYPE);
    }

    private static <T extends StructureProcessor> void registerProcessor(String name, T processor, StructureProcessorType<T> type) {
        ResourceLocation res = new ResourceLocation("quark", name);
        Registry.m_122965_((Registry)Registry.f_122891_, (ResourceLocation)res, type);
        Registry.m_122965_((Registry)BuiltinRegistries.f_123863_, (ResourceLocation)res, (Object)new StructureProcessorList((List)Lists.newArrayList((Object[])new StructureProcessor[]{processor})));
    }
}

