/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.lucko.spark.proto.SparkSamplerProtos;

public interface ThreadGrouper {
    public static final ThreadGrouper BY_NAME = new ThreadGrouper(){

        @Override
        public String getGroup(long threadId, String threadName) {
            return threadName;
        }

        @Override
        public SparkSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper asProto() {
            return SparkSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper.BY_NAME;
        }
    };
    public static final ThreadGrouper BY_POOL = new ThreadGrouper(){
        private final Map<Long, String> cache = new ConcurrentHashMap<Long, String>();
        private final Pattern pattern = Pattern.compile("^(.*?)[-# ]+\\d+$");

        @Override
        public String getGroup(long threadId, String threadName) {
            String group = this.cache.get(threadId);
            if (group != null) {
                return group;
            }
            Matcher matcher = this.pattern.matcher(threadName);
            if (!matcher.matches()) {
                return threadName;
            }
            group = matcher.group(1).trim() + " (Combined)";
            this.cache.put(threadId, group);
            return group;
        }

        @Override
        public SparkSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper asProto() {
            return SparkSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper.BY_POOL;
        }
    };
    public static final ThreadGrouper AS_ONE = new ThreadGrouper(){

        @Override
        public String getGroup(long threadId, String threadName) {
            return "All";
        }

        @Override
        public SparkSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper asProto() {
            return SparkSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper.AS_ONE;
        }
    };

    public String getGroup(long var1, String var3);

    public SparkSamplerProtos.SamplerMetadata.DataAggregator.ThreadGrouper asProto();
}

