/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons;

import com.tterrag.registrate.providers.ProviderType;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import rbasamoyai.createbigcannons.CreateBigCannons;

public class CBCTags {
    public static void register() {
        BlockCBC.sectionRegister();
        ItemCBC.sectionRegister();
    }

    private static ResourceLocation alloyed(String path) {
        return new ResourceLocation("alloyed", path);
    }

    private static ResourceLocation createdeco(String path) {
        return new ResourceLocation("createdeco", path);
    }

    public static class BlockCBC {
        public static final TagKey<Block> THICK_TUBING = BlockCBC.createAndGenerateBlockTag(CreateBigCannons.resource("thick_tubing"));
        public static final TagKey<Block> REDUCES_SPREAD = BlockCBC.createAndGenerateBlockTag(CreateBigCannons.resource("reduces_spread"));
        public static final TagKey<Block> WEAK_CANNON_END = BlockCBC.createAndGenerateBlockTag(CreateBigCannons.resource("weak_cannon_end"));
        public static final TagKey<Block> DRILL_CAN_PASS_THROUGH = BlockCBC.createAndGenerateBlockTag(CreateBigCannons.resource("drill_can_pass_through"));
        public static final TagKey<Block> DEFLECTS_SHOTS = BlockCBC.createAndGenerateBlockTag(CreateBigCannons.resource("deflects_shots"));
        public static final TagKey<Block> DOESNT_DEFLECT_SHOTS = BlockCBC.createAndGenerateBlockTag(CreateBigCannons.resource("doesnt_deflect_shots"));
        public static final TagKey<Block> BOUNCES_SHOTS = BlockCBC.createAndGenerateBlockTag(CreateBigCannons.resource("bounces_shots"));
        public static final TagKey<Block> DOESNT_BOUNCE_SHOTS = BlockCBC.createAndGenerateBlockTag(CreateBigCannons.resource("doesnt_bounce_shots"));

        public static TagKey<Block> createAndGenerateBlockTag(ResourceLocation loc) {
            TagKey tag = BlockTags.create((ResourceLocation)loc);
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(tag));
            return tag;
        }

        public static void addBlocksToBlockTag(TagKey<Block> tag, Block ... blocks) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> prov.m_206424_(tag).m_126584_((Object[])blocks));
        }

        public static void addBlocksToBlockTag(TagKey<Block> tag, Supplier<List<? extends Block>> blocks) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (Block b : (List)blocks.get()) {
                    app.m_126582_((Object)b);
                }
            });
        }

        public static void addTagsToBlockTag(TagKey<Block> tag, Supplier<List<TagKey<Block>>> tags) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                ((List)tags.get()).forEach(arg_0 -> ((TagsProvider.TagAppender)app).m_206428_(arg_0));
            });
        }

        public static void sectionRegister() {
        }
    }

    public static class ItemCBC {
        public static final TagKey<Item> IMPACT_FUZE_HEAD = ItemCBC.createAndGenerateItemTag(CreateBigCannons.resource("impact_fuze_head"));
        public static final TagKey<Item> NUGGET_CAST_IRON = ItemCBC.forgeTag("nuggets/cast_iron");
        public static final TagKey<Item> INGOT_CAST_IRON = ItemCBC.forgeTag("ingots/cast_iron");
        public static final TagKey<Item> BLOCK_CAST_IRON = ItemCBC.forgeTag("storage_blocks/cast_iron");
        public static final TagKey<Item> NUGGET_BRONZE = ItemCBC.forgeTag("nuggets/bronze");
        public static final TagKey<Item> INGOT_BRONZE = ItemCBC.forgeTag("ingots/bronze");
        public static final TagKey<Item> BLOCK_BRONZE = ItemCBC.forgeTag("storage_blocks/bronze");
        public static final TagKey<Item> NUGGET_STEEL = ItemCBC.forgeTag("nuggets/steel");
        public static final TagKey<Item> INGOT_STEEL = ItemCBC.forgeTag("ingots/steel");
        public static final TagKey<Item> BLOCK_STEEL = ItemCBC.forgeTag("storage_blocks/steel");

        public static TagKey<Item> createAndGenerateItemTag(ResourceLocation loc) {
            TagKey tag = ItemTags.create((ResourceLocation)loc);
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(tag));
            return tag;
        }

        public static TagKey<Item> forgeTag(String path) {
            TagKey tag = ForgeRegistries.ITEMS.tags().createOptionalTagKey(new ResourceLocation("forge", path), Collections.emptySet());
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(tag));
            return tag;
        }

        public static void addItemsToItemTag(TagKey<Item> tag, Item ... items) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> prov.m_206424_(tag).m_126584_((Object[])items));
        }

        public static void addItemsToItemTag(TagKey<Item> tag, ItemLike ... items) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (ItemLike bp : items) {
                    app.m_126582_((Object)bp.m_5456_());
                }
            });
        }

        public static void addTagsToItemTag(TagKey<Item> tag, List<TagKey<Item>> tags) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                tags.forEach(arg_0 -> ((TagsProvider.TagAppender)app).m_206428_(arg_0));
            });
        }

        public static void addIdsToItemTag(TagKey<Item> tag, ResourceLocation ... ids) {
            CreateBigCannons.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, prov -> {
                TagsProvider.TagAppender app = prov.m_206424_(tag);
                for (ResourceLocation id : ids) {
                    app.m_176839_(id);
                }
            });
        }

        public static void sectionRegister() {
            ItemCBC.addItemsToItemTag(IMPACT_FUZE_HEAD, Items.f_42083_, Items.f_42145_);
            ItemCBC.addIdsToItemTag(BLOCK_BRONZE, CBCTags.alloyed("bronze_block"));
            ItemCBC.addIdsToItemTag(BLOCK_STEEL, CBCTags.alloyed("steel_block"));
            ItemCBC.addIdsToItemTag(BLOCK_CAST_IRON, CBCTags.createdeco("cast_iron_block"));
        }
    }
}

