/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.player.Input;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import rbasamoyai.createbigcannons.CBCBlockPartials;
import rbasamoyai.createbigcannons.CBCFluids;
import rbasamoyai.createbigcannons.CBCItems;
import rbasamoyai.createbigcannons.CBCParticleTypes;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.cannon_control.carriage.CannonCarriageEntity;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannon_control.effects.CannonPlumeParticle;
import rbasamoyai.createbigcannons.cannon_control.effects.CannonSmokeParticle;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobParticle;
import rbasamoyai.createbigcannons.network.CBCNetwork;
import rbasamoyai.createbigcannons.network.ServerboundFiringActionPacket;
import rbasamoyai.createbigcannons.network.ServerboundSetFireRatePacket;
import rbasamoyai.createbigcannons.ponder.CBCPonderIndex;

public class CreateBigCannonsClient {
    private static final String KEY_ROOT = "key.createbigcannons";
    private static final String KEY_CATEGORY = "key.createbigcannons.category";
    public static final KeyMapping PITCH_MODE = new KeyMapping("key.createbigcannons.pitch_mode", 67, "key.createbigcannons.category");
    public static final KeyMapping FIRE_CONTROLLED_CANNON = new KeyMapping("key.createbigcannons.fire_controlled_cannon", InputConstants.Type.MOUSE, 0, "key.createbigcannons.category");

    public static void prepareClient(IEventBus modEventBus, IEventBus forgeEventBus) {
        CBCBlockPartials.init();
        modEventBus.addListener(CreateBigCannonsClient::onClientSetup);
        modEventBus.addListener(CreateBigCannonsClient::onRegisterParticleFactories);
        modEventBus.addListener(CreateBigCannonsClient::onKeyRegistry);
        forgeEventBus.addListener(CreateBigCannonsClient::getFogColor);
        forgeEventBus.addListener(CreateBigCannonsClient::getFogDensity);
        forgeEventBus.addListener(CreateBigCannonsClient::onClientGameTick);
        forgeEventBus.addListener(CreateBigCannonsClient::onScrollMouse);
        forgeEventBus.addListener(CreateBigCannonsClient::onFovModify);
        forgeEventBus.addListener(CreateBigCannonsClient::onPlayerRenderPre);
    }

    public static void onRegisterParticleFactories(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)CBCParticleTypes.CANNON_PLUME.get(), (ParticleProvider)new CannonPlumeParticle.Provider());
        event.register((ParticleType)CBCParticleTypes.FLUID_BLOB.get(), (ParticleProvider)new FluidBlobParticle.Provider());
        event.register((ParticleType)CBCParticleTypes.CANNON_SMOKE.get(), CannonSmokeParticle.Provider::new);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        CBCPonderIndex.register();
        CBCPonderIndex.registerTags();
        CBCBlockPartials.resolveDeferredModels();
        ItemProperties.register((Item)((Item)CBCItems.PARTIALLY_FORMED_AUTOCANNON_CARTRIDGE.get()), (ResourceLocation)CreateBigCannons.resource("formed"), (stack, level, player, a) -> stack.m_41784_().m_128469_("SequencedAssembly").m_128451_("Step") - 1);
    }

    public static void onKeyRegistry(RegisterKeyMappingsEvent evt) {
        evt.register(PITCH_MODE);
        evt.register(FIRE_CONTROLLED_CANNON);
    }

    public static void getFogColor(ViewportEvent.ComputeFogColor event) {
        Camera info = event.getCamera();
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        BlockPos blockPos = info.m_90588_();
        FluidState fluidState = level.m_6425_(blockPos);
        if (info.m_90583_().f_82480_ > (double)((float)blockPos.m_123342_() + fluidState.m_76155_((BlockGetter)level, blockPos))) {
            return;
        }
        Fluid fluid = fluidState.m_76152_();
        if (((ForgeFlowingFluid.Flowing)CBCFluids.MOLTEN_CAST_IRON.get()).m_6212_(fluid)) {
            event.setRed(0.27450982f);
            event.setGreen(0.039215688f);
            event.setBlue(0.043137256f);
            return;
        }
        if (((ForgeFlowingFluid.Flowing)CBCFluids.MOLTEN_BRONZE.get()).m_6212_(fluid)) {
            event.setRed(0.3882353f);
            event.setGreen(0.25882354f);
            event.setBlue(0.08627451f);
            return;
        }
        if (((ForgeFlowingFluid.Flowing)CBCFluids.MOLTEN_STEEL.get()).m_6212_(fluid)) {
            event.setRed(0.43529412f);
            event.setGreen(0.43137255f);
            event.setBlue(0.41568628f);
            return;
        }
        if (((ForgeFlowingFluid.Flowing)CBCFluids.MOLTEN_NETHERSTEEL.get()).m_6212_(fluid)) {
            event.setRed(0.29803923f);
            event.setGreen(0.19607843f);
            event.setBlue(0.22745098f);
            return;
        }
    }

    public static void getFogDensity(ViewportEvent.RenderFog event) {
        if (!event.isCancelable()) {
            return;
        }
        Camera info = event.getCamera();
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        BlockPos blockPos = info.m_90588_();
        FluidState fluidState = level.m_6425_(blockPos);
        if (info.m_90583_().f_82480_ > (double)((float)blockPos.m_123342_() + fluidState.m_76155_((BlockGetter)level, blockPos))) {
            return;
        }
        Fluid fluid = fluidState.m_76152_();
        List<Fluid> moltenMetals = Arrays.asList((Fluid)CBCFluids.MOLTEN_CAST_IRON.get(), (Fluid)CBCFluids.MOLTEN_BRONZE.get(), (Fluid)CBCFluids.MOLTEN_STEEL.get(), (Fluid)CBCFluids.MOLTEN_NETHERSTEEL.get());
        for (Fluid fluid1 : moltenMetals) {
            if (!fluid1.m_6212_(fluid)) continue;
            event.scaleFarPlaneDistance(0.03125f);
            event.setCanceled(true);
            return;
        }
    }

    public static void onClientGameTick(TickEvent.ClientTickEvent evt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        Entity entity = mc.f_91074_.m_20201_();
        if (entity instanceof CannonCarriageEntity) {
            CannonCarriageEntity carriage = (CannonCarriageEntity)entity;
            Input input = mc.f_91074_.f_108618_;
            boolean isPitching = PITCH_MODE.m_90857_();
            carriage.setInput(input.f_108570_, input.f_108571_, input.f_108568_, input.f_108569_, isPitching);
            mc.f_91074_.f_108611_ |= input.f_108570_ | input.f_108571_ | input.f_108568_ | input.f_108569_;
        }
        if (FIRE_CONTROLLED_CANNON.m_90857_() && CreateBigCannonsClient.isControllingCannon((Entity)mc.f_91074_)) {
            mc.f_91074_.f_108611_ = true;
            CBCNetwork.INSTANCE.sendToServer((Object)new ServerboundFiringActionPacket());
        }
    }

    public static void onScrollMouse(InputEvent.MouseScrollingEvent evt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (mc.f_91074_.m_20201_() instanceof CannonCarriageEntity) {
            double scrollDelta = evt.getScrollDelta();
            int fireRateAdjustment = 0;
            if (scrollDelta > 0.0) {
                fireRateAdjustment = 1;
            } else if (scrollDelta < 0.0) {
                fireRateAdjustment = -1;
            }
            if (fireRateAdjustment != 0) {
                mc.f_91074_.f_108611_ = true;
                CBCNetwork.INSTANCE.sendToServer((Object)new ServerboundSetFireRatePacket(fireRateAdjustment));
                if (evt.isCancelable()) {
                    evt.setCanceled(true);
                }
            }
        }
    }

    public static void onFovModify(ComputeFovModifierEvent evt) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || !mc.f_91066_.m_92176_().m_90612_()) {
            return;
        }
        if (mc.f_91066_.f_92095_.m_90857_() && CreateBigCannonsClient.isControllingCannon((Entity)mc.f_91074_)) {
            evt.setNewFovModifier(evt.getFovModifier() * 0.5f);
        }
    }

    public static void onPlayerRenderPre(RenderPlayerEvent.Pre evt) {
        PitchOrientedContraptionEntity poce;
        PoseStack stack = evt.getPoseStack();
        Player player = evt.getEntity();
        float pt = evt.getPartialTick();
        Entity entity = player.m_20202_();
        if (entity instanceof PitchOrientedContraptionEntity && (poce = (PitchOrientedContraptionEntity)entity).getSeatPos((Entity)player) != null) {
            Vector3f pVec = new Vector3f(player.m_20318_(pt));
            stack.m_85837_((double)(-pVec.m_122239_()), (double)(-pVec.m_122260_()), (double)(-pVec.m_122269_()));
            BlockPos seatPos = poce.getSeatPos((Entity)player);
            double offs = (double)player.m_20192_() + player.m_6049_() - 0.15;
            Vec3 vec = new Vec3(poce.getInitialOrientation().m_122432_()).m_82490_(0.25);
            Vector3f pVec1 = new Vector3f(poce.toGlobalVector(Vec3.m_82512_((Vec3i)seatPos).m_82546_(vec).m_82492_(0.0, offs, 0.0), pt));
            stack.m_85837_((double)pVec1.m_122239_(), (double)pVec1.m_122260_(), (double)pVec1.m_122269_());
            float yr = (-Mth.m_14179_((float)pt, (float)player.f_19859_, (float)player.m_146908_()) + 90.0f) * ((float)Math.PI / 180);
            Vector3f vec3 = new Vector3f(Mth.m_14031_((float)yr), 0.0f, Mth.m_14089_((float)yr));
            float xr = Mth.m_14179_((float)pt, (float)player.f_19860_, (float)player.m_146909_());
            stack.m_85845_(vec3.m_122240_(xr));
        }
    }

    private static boolean isControllingCannon(Entity entity) {
        Entity vehicle = entity.m_20202_();
        return vehicle instanceof CannonCarriageEntity || vehicle instanceof PitchOrientedContraptionEntity;
    }
}

